/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.EnvironmentError;
import com.amazonaws.services.lambda.model.transform.EnvironmentResponseMarshaller;
import java.io.Serializable;
import java.util.Map;

public class EnvironmentResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalMap<String, String> variables;
    private EnvironmentError error;

    public Map<String, String> getVariables() {
        if (this.variables == null) {
            this.variables = new SdkInternalMap();
        }
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables == null ? null : new SdkInternalMap(variables);
    }

    public EnvironmentResponse withVariables(Map<String, String> variables) {
        this.setVariables(variables);
        return this;
    }

    public EnvironmentResponse addVariablesEntry(String key, String value) {
        if (null == this.variables) {
            this.variables = new SdkInternalMap();
        }
        if (this.variables.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.variables.put((Object)key, (Object)value);
        return this;
    }

    public EnvironmentResponse clearVariablesEntries() {
        this.variables = null;
        return this;
    }

    public void setError(EnvironmentError error) {
        this.error = error;
    }

    public EnvironmentError getError() {
        return this.error;
    }

    public EnvironmentResponse withError(EnvironmentError error) {
        this.setError(error);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResponse)) {
            return false;
        }
        EnvironmentResponse other = (EnvironmentResponse)obj;
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        return other.getError() == null || other.getError().equals(this.getError());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        return hashCode;
    }

    public EnvironmentResponse clone() {
        try {
            return (EnvironmentResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

