/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lambda.model.LayerVersionContentOutput;

@SdkInternalApi
public class LayerVersionContentOutputMarshaller {
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final MarshallingInfo<String> CODESHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSha256").build();
    private static final MarshallingInfo<Long> CODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSize").build();
    private static final LayerVersionContentOutputMarshaller instance = new LayerVersionContentOutputMarshaller();

    public static LayerVersionContentOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(LayerVersionContentOutput layerVersionContentOutput, ProtocolMarshaller protocolMarshaller) {
        if (layerVersionContentOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)layerVersionContentOutput.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)layerVersionContentOutput.getCodeSha256(), CODESHA256_BINDING);
            protocolMarshaller.marshall((Object)layerVersionContentOutput.getCodeSize(), CODESIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

