/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import com.amazonaws.services.lambda.model.transform.EnvironmentResponseJsonMarshaller;
import com.amazonaws.services.lambda.model.transform.VpcConfigResponseJsonMarshaller;

public class FunctionConfigurationJsonMarshaller {
    private static FunctionConfigurationJsonMarshaller instance;

    public void marshall(FunctionConfiguration functionConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (functionConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (functionConfiguration.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(functionConfiguration.getFunctionName());
            }
            if (functionConfiguration.getFunctionArn() != null) {
                jsonGenerator.writeFieldName("FunctionArn").writeValue(functionConfiguration.getFunctionArn());
            }
            if (functionConfiguration.getRuntime() != null) {
                jsonGenerator.writeFieldName("Runtime").writeValue(functionConfiguration.getRuntime());
            }
            if (functionConfiguration.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(functionConfiguration.getRole());
            }
            if (functionConfiguration.getHandler() != null) {
                jsonGenerator.writeFieldName("Handler").writeValue(functionConfiguration.getHandler());
            }
            if (functionConfiguration.getCodeSize() != null) {
                jsonGenerator.writeFieldName("CodeSize").writeValue(functionConfiguration.getCodeSize().longValue());
            }
            if (functionConfiguration.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(functionConfiguration.getDescription());
            }
            if (functionConfiguration.getTimeout() != null) {
                jsonGenerator.writeFieldName("Timeout").writeValue(functionConfiguration.getTimeout().intValue());
            }
            if (functionConfiguration.getMemorySize() != null) {
                jsonGenerator.writeFieldName("MemorySize").writeValue(functionConfiguration.getMemorySize().intValue());
            }
            if (functionConfiguration.getLastModified() != null) {
                jsonGenerator.writeFieldName("LastModified").writeValue(functionConfiguration.getLastModified());
            }
            if (functionConfiguration.getCodeSha256() != null) {
                jsonGenerator.writeFieldName("CodeSha256").writeValue(functionConfiguration.getCodeSha256());
            }
            if (functionConfiguration.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(functionConfiguration.getVersion());
            }
            if (functionConfiguration.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigResponseJsonMarshaller.getInstance().marshall(functionConfiguration.getVpcConfig(), jsonGenerator);
            }
            if (functionConfiguration.getEnvironment() != null) {
                jsonGenerator.writeFieldName("Environment");
                EnvironmentResponseJsonMarshaller.getInstance().marshall(functionConfiguration.getEnvironment(), jsonGenerator);
            }
            if (functionConfiguration.getKMSKeyArn() != null) {
                jsonGenerator.writeFieldName("KMSKeyArn").writeValue(functionConfiguration.getKMSKeyArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FunctionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FunctionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

