/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PublishVersionRequestMarshaller
implements Marshaller<Request<PublishVersionRequest>, PublishVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PublishVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PublishVersionRequest> marshall(PublishVersionRequest publishVersionRequest) {
        if (publishVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishVersionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/versions";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", publishVersionRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (publishVersionRequest.getCodeSha256() != null) {
                jsonGenerator.writeFieldName("CodeSha256").writeValue(publishVersionRequest.getCodeSha256());
            }
            if (publishVersionRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(publishVersionRequest.getDescription());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

