/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InvokeRequestMarshaller
implements Marshaller<Request<InvokeRequest>, InvokeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InvokeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InvokeRequest> marshall(InvokeRequest invokeRequest) {
        if (invokeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)invokeRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        if (invokeRequest.getInvocationType() != null) {
            request.addHeader("X-Amz-Invocation-Type", StringUtils.fromString((String)invokeRequest.getInvocationType()));
        }
        if (invokeRequest.getLogType() != null) {
            request.addHeader("X-Amz-Log-Type", StringUtils.fromString((String)invokeRequest.getLogType()));
        }
        if (invokeRequest.getClientContext() != null) {
            request.addHeader("X-Amz-Client-Context", StringUtils.fromString((String)invokeRequest.getClientContext()));
        }
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/invocations";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", invokeRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        if (invokeRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString((String)invokeRequest.getQualifier()));
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)invokeRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

