/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.Architecture;
import com.amazonaws.services.lambda.model.Runtime;
import com.amazonaws.services.lambda.model.transform.LayerVersionsListItemMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class LayerVersionsListItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String layerVersionArn;
    private Long version;
    private String description;
    private String createdDate;
    private SdkInternalList<String> compatibleRuntimes;
    private String licenseInfo;
    private SdkInternalList<String> compatibleArchitectures;

    public void setLayerVersionArn(String layerVersionArn) {
        this.layerVersionArn = layerVersionArn;
    }

    public String getLayerVersionArn() {
        return this.layerVersionArn;
    }

    public LayerVersionsListItem withLayerVersionArn(String layerVersionArn) {
        this.setLayerVersionArn(layerVersionArn);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public LayerVersionsListItem withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public LayerVersionsListItem withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public LayerVersionsListItem withCreatedDate(String createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public List<String> getCompatibleRuntimes() {
        if (this.compatibleRuntimes == null) {
            this.compatibleRuntimes = new SdkInternalList();
        }
        return this.compatibleRuntimes;
    }

    public void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
        if (compatibleRuntimes == null) {
            this.compatibleRuntimes = null;
            return;
        }
        this.compatibleRuntimes = new SdkInternalList(compatibleRuntimes);
    }

    public LayerVersionsListItem withCompatibleRuntimes(String ... compatibleRuntimes) {
        if (this.compatibleRuntimes == null) {
            this.setCompatibleRuntimes((Collection<String>)new SdkInternalList(compatibleRuntimes.length));
        }
        for (String ele : compatibleRuntimes) {
            this.compatibleRuntimes.add((Object)ele);
        }
        return this;
    }

    public LayerVersionsListItem withCompatibleRuntimes(Collection<String> compatibleRuntimes) {
        this.setCompatibleRuntimes(compatibleRuntimes);
        return this;
    }

    public LayerVersionsListItem withCompatibleRuntimes(Runtime ... compatibleRuntimes) {
        SdkInternalList compatibleRuntimesCopy = new SdkInternalList(compatibleRuntimes.length);
        for (Runtime value : compatibleRuntimes) {
            compatibleRuntimesCopy.add((Object)value.toString());
        }
        if (this.getCompatibleRuntimes() == null) {
            this.setCompatibleRuntimes((Collection<String>)compatibleRuntimesCopy);
        } else {
            this.getCompatibleRuntimes().addAll((Collection<String>)compatibleRuntimesCopy);
        }
        return this;
    }

    public void setLicenseInfo(String licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public String getLicenseInfo() {
        return this.licenseInfo;
    }

    public LayerVersionsListItem withLicenseInfo(String licenseInfo) {
        this.setLicenseInfo(licenseInfo);
        return this;
    }

    public List<String> getCompatibleArchitectures() {
        if (this.compatibleArchitectures == null) {
            this.compatibleArchitectures = new SdkInternalList();
        }
        return this.compatibleArchitectures;
    }

    public void setCompatibleArchitectures(Collection<String> compatibleArchitectures) {
        if (compatibleArchitectures == null) {
            this.compatibleArchitectures = null;
            return;
        }
        this.compatibleArchitectures = new SdkInternalList(compatibleArchitectures);
    }

    public LayerVersionsListItem withCompatibleArchitectures(String ... compatibleArchitectures) {
        if (this.compatibleArchitectures == null) {
            this.setCompatibleArchitectures((Collection<String>)new SdkInternalList(compatibleArchitectures.length));
        }
        for (String ele : compatibleArchitectures) {
            this.compatibleArchitectures.add((Object)ele);
        }
        return this;
    }

    public LayerVersionsListItem withCompatibleArchitectures(Collection<String> compatibleArchitectures) {
        this.setCompatibleArchitectures(compatibleArchitectures);
        return this;
    }

    public LayerVersionsListItem withCompatibleArchitectures(Architecture ... compatibleArchitectures) {
        SdkInternalList compatibleArchitecturesCopy = new SdkInternalList(compatibleArchitectures.length);
        for (Architecture value : compatibleArchitectures) {
            compatibleArchitecturesCopy.add((Object)value.toString());
        }
        if (this.getCompatibleArchitectures() == null) {
            this.setCompatibleArchitectures((Collection<String>)compatibleArchitecturesCopy);
        } else {
            this.getCompatibleArchitectures().addAll((Collection<String>)compatibleArchitecturesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLayerVersionArn() != null) {
            sb.append("LayerVersionArn: ").append(this.getLayerVersionArn()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCreatedDate() != null) {
            sb.append("CreatedDate: ").append(this.getCreatedDate()).append(",");
        }
        if (this.getCompatibleRuntimes() != null) {
            sb.append("CompatibleRuntimes: ").append(this.getCompatibleRuntimes()).append(",");
        }
        if (this.getLicenseInfo() != null) {
            sb.append("LicenseInfo: ").append(this.getLicenseInfo()).append(",");
        }
        if (this.getCompatibleArchitectures() != null) {
            sb.append("CompatibleArchitectures: ").append(this.getCompatibleArchitectures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionsListItem)) {
            return false;
        }
        LayerVersionsListItem other = (LayerVersionsListItem)obj;
        if (other.getLayerVersionArn() == null ^ this.getLayerVersionArn() == null) {
            return false;
        }
        if (other.getLayerVersionArn() != null && !other.getLayerVersionArn().equals(this.getLayerVersionArn())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null) {
            return false;
        }
        if (other.getCreatedDate() != null && !other.getCreatedDate().equals(this.getCreatedDate())) {
            return false;
        }
        if (other.getCompatibleRuntimes() == null ^ this.getCompatibleRuntimes() == null) {
            return false;
        }
        if (other.getCompatibleRuntimes() != null && !other.getCompatibleRuntimes().equals(this.getCompatibleRuntimes())) {
            return false;
        }
        if (other.getLicenseInfo() == null ^ this.getLicenseInfo() == null) {
            return false;
        }
        if (other.getLicenseInfo() != null && !other.getLicenseInfo().equals(this.getLicenseInfo())) {
            return false;
        }
        if (other.getCompatibleArchitectures() == null ^ this.getCompatibleArchitectures() == null) {
            return false;
        }
        return other.getCompatibleArchitectures() == null || other.getCompatibleArchitectures().equals(this.getCompatibleArchitectures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLayerVersionArn() == null ? 0 : this.getLayerVersionArn().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedDate() == null ? 0 : this.getCreatedDate().hashCode());
        hashCode = 31 * hashCode + (this.getCompatibleRuntimes() == null ? 0 : this.getCompatibleRuntimes().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseInfo() == null ? 0 : this.getLicenseInfo().hashCode());
        hashCode = 31 * hashCode + (this.getCompatibleArchitectures() == null ? 0 : this.getCompatibleArchitectures().hashCode());
        return hashCode;
    }

    public LayerVersionsListItem clone() {
        try {
            return (LayerVersionsListItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LayerVersionsListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

