/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.lambda.model.FunctionConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListFunctionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextMarker;
    private SdkInternalList<FunctionConfiguration> functions;

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListFunctionsResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public List<FunctionConfiguration> getFunctions() {
        if (this.functions == null) {
            this.functions = new SdkInternalList();
        }
        return this.functions;
    }

    public void setFunctions(Collection<FunctionConfiguration> functions) {
        if (functions == null) {
            this.functions = null;
            return;
        }
        this.functions = new SdkInternalList(functions);
    }

    public ListFunctionsResult withFunctions(FunctionConfiguration ... functions) {
        if (this.functions == null) {
            this.setFunctions((Collection<FunctionConfiguration>)new SdkInternalList(functions.length));
        }
        for (FunctionConfiguration ele : functions) {
            this.functions.add((Object)ele);
        }
        return this;
    }

    public ListFunctionsResult withFunctions(Collection<FunctionConfiguration> functions) {
        this.setFunctions(functions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getFunctions() != null) {
            sb.append("Functions: ").append(this.getFunctions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResult)) {
            return false;
        }
        ListFunctionsResult other = (ListFunctionsResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getFunctions() == null ^ this.getFunctions() == null) {
            return false;
        }
        return other.getFunctions() == null || other.getFunctions().equals(this.getFunctions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getFunctions() == null ? 0 : this.getFunctions().hashCode());
        return hashCode;
    }

    public ListFunctionsResult clone() {
        try {
            return (ListFunctionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

