/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.lambda.model.Architecture;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class UpdateFunctionCodeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String functionName;
    private ByteBuffer zipFile;
    private String s3Bucket;
    private String s3Key;
    private String s3ObjectVersion;
    private String imageUri;
    private Boolean publish;
    private Boolean dryRun;
    private String revisionId;
    private SdkInternalList<String> architectures;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public UpdateFunctionCodeRequest withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void setZipFile(ByteBuffer zipFile) {
        this.zipFile = zipFile;
    }

    public ByteBuffer getZipFile() {
        return this.zipFile;
    }

    public UpdateFunctionCodeRequest withZipFile(ByteBuffer zipFile) {
        this.setZipFile(zipFile);
        return this;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public UpdateFunctionCodeRequest withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3Key(String s3Key) {
        this.s3Key = s3Key;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public UpdateFunctionCodeRequest withS3Key(String s3Key) {
        this.setS3Key(s3Key);
        return this;
    }

    public void setS3ObjectVersion(String s3ObjectVersion) {
        this.s3ObjectVersion = s3ObjectVersion;
    }

    public String getS3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public UpdateFunctionCodeRequest withS3ObjectVersion(String s3ObjectVersion) {
        this.setS3ObjectVersion(s3ObjectVersion);
        return this;
    }

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public UpdateFunctionCodeRequest withImageUri(String imageUri) {
        this.setImageUri(imageUri);
        return this;
    }

    public void setPublish(Boolean publish) {
        this.publish = publish;
    }

    public Boolean getPublish() {
        return this.publish;
    }

    public UpdateFunctionCodeRequest withPublish(Boolean publish) {
        this.setPublish(publish);
        return this;
    }

    public Boolean isPublish() {
        return this.publish;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public UpdateFunctionCodeRequest withDryRun(Boolean dryRun) {
        this.setDryRun(dryRun);
        return this;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public UpdateFunctionCodeRequest withRevisionId(String revisionId) {
        this.setRevisionId(revisionId);
        return this;
    }

    public List<String> getArchitectures() {
        if (this.architectures == null) {
            this.architectures = new SdkInternalList();
        }
        return this.architectures;
    }

    public void setArchitectures(Collection<String> architectures) {
        if (architectures == null) {
            this.architectures = null;
            return;
        }
        this.architectures = new SdkInternalList(architectures);
    }

    public UpdateFunctionCodeRequest withArchitectures(String ... architectures) {
        if (this.architectures == null) {
            this.setArchitectures((Collection<String>)new SdkInternalList(architectures.length));
        }
        for (String ele : architectures) {
            this.architectures.add((Object)ele);
        }
        return this;
    }

    public UpdateFunctionCodeRequest withArchitectures(Collection<String> architectures) {
        this.setArchitectures(architectures);
        return this;
    }

    public UpdateFunctionCodeRequest withArchitectures(Architecture ... architectures) {
        SdkInternalList architecturesCopy = new SdkInternalList(architectures.length);
        for (Architecture value : architectures) {
            architecturesCopy.add((Object)value.toString());
        }
        if (this.getArchitectures() == null) {
            this.setArchitectures((Collection<String>)architecturesCopy);
        } else {
            this.getArchitectures().addAll((Collection<String>)architecturesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getZipFile() != null) {
            sb.append("ZipFile: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3Key() != null) {
            sb.append("S3Key: ").append(this.getS3Key()).append(",");
        }
        if (this.getS3ObjectVersion() != null) {
            sb.append("S3ObjectVersion: ").append(this.getS3ObjectVersion()).append(",");
        }
        if (this.getImageUri() != null) {
            sb.append("ImageUri: ").append(this.getImageUri()).append(",");
        }
        if (this.getPublish() != null) {
            sb.append("Publish: ").append(this.getPublish()).append(",");
        }
        if (this.getDryRun() != null) {
            sb.append("DryRun: ").append(this.getDryRun()).append(",");
        }
        if (this.getRevisionId() != null) {
            sb.append("RevisionId: ").append(this.getRevisionId()).append(",");
        }
        if (this.getArchitectures() != null) {
            sb.append("Architectures: ").append(this.getArchitectures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionCodeRequest)) {
            return false;
        }
        UpdateFunctionCodeRequest other = (UpdateFunctionCodeRequest)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getZipFile() == null ^ this.getZipFile() == null) {
            return false;
        }
        if (other.getZipFile() != null && !other.getZipFile().equals(this.getZipFile())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3Key() == null ^ this.getS3Key() == null) {
            return false;
        }
        if (other.getS3Key() != null && !other.getS3Key().equals(this.getS3Key())) {
            return false;
        }
        if (other.getS3ObjectVersion() == null ^ this.getS3ObjectVersion() == null) {
            return false;
        }
        if (other.getS3ObjectVersion() != null && !other.getS3ObjectVersion().equals(this.getS3ObjectVersion())) {
            return false;
        }
        if (other.getImageUri() == null ^ this.getImageUri() == null) {
            return false;
        }
        if (other.getImageUri() != null && !other.getImageUri().equals(this.getImageUri())) {
            return false;
        }
        if (other.getPublish() == null ^ this.getPublish() == null) {
            return false;
        }
        if (other.getPublish() != null && !other.getPublish().equals(this.getPublish())) {
            return false;
        }
        if (other.getDryRun() == null ^ this.getDryRun() == null) {
            return false;
        }
        if (other.getDryRun() != null && !other.getDryRun().equals(this.getDryRun())) {
            return false;
        }
        if (other.getRevisionId() == null ^ this.getRevisionId() == null) {
            return false;
        }
        if (other.getRevisionId() != null && !other.getRevisionId().equals(this.getRevisionId())) {
            return false;
        }
        if (other.getArchitectures() == null ^ this.getArchitectures() == null) {
            return false;
        }
        return other.getArchitectures() == null || other.getArchitectures().equals(this.getArchitectures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getZipFile() == null ? 0 : this.getZipFile().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3Key() == null ? 0 : this.getS3Key().hashCode());
        hashCode = 31 * hashCode + (this.getS3ObjectVersion() == null ? 0 : this.getS3ObjectVersion().hashCode());
        hashCode = 31 * hashCode + (this.getImageUri() == null ? 0 : this.getImageUri().hashCode());
        hashCode = 31 * hashCode + (this.getPublish() == null ? 0 : this.getPublish().hashCode());
        hashCode = 31 * hashCode + (this.getDryRun() == null ? 0 : this.getDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionId() == null ? 0 : this.getRevisionId().hashCode());
        hashCode = 31 * hashCode + (this.getArchitectures() == null ? 0 : this.getArchitectures().hashCode());
        return hashCode;
    }

    public UpdateFunctionCodeRequest clone() {
        return (UpdateFunctionCodeRequest)super.clone();
    }
}

