/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.VorbisSettings;

@SdkInternalApi
public class VorbisSettingsMarshaller {
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final MarshallingInfo<Integer> VBRQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vbrQuality").build();
    private static final VorbisSettingsMarshaller instance = new VorbisSettingsMarshaller();

    public static VorbisSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(VorbisSettings vorbisSettings, ProtocolMarshaller protocolMarshaller) {
        if (vorbisSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vorbisSettings.getChannels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)vorbisSettings.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)vorbisSettings.getVbrQuality(), VBRQUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

