/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.EngineType;
import com.amazonaws.services.mq.model.EngineVersion;
import com.amazonaws.services.mq.model.transform.BrokerEngineTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrokerEngineType
implements Serializable,
Cloneable,
StructuredPojo {
    private String engineType;
    private List<EngineVersion> engineVersions;

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public BrokerEngineType withEngineType(String engineType) {
        this.setEngineType(engineType);
        return this;
    }

    public BrokerEngineType withEngineType(EngineType engineType) {
        this.engineType = engineType.toString();
        return this;
    }

    public List<EngineVersion> getEngineVersions() {
        return this.engineVersions;
    }

    public void setEngineVersions(Collection<EngineVersion> engineVersions) {
        if (engineVersions == null) {
            this.engineVersions = null;
            return;
        }
        this.engineVersions = new ArrayList<EngineVersion>(engineVersions);
    }

    public BrokerEngineType withEngineVersions(EngineVersion ... engineVersions) {
        if (this.engineVersions == null) {
            this.setEngineVersions(new ArrayList<EngineVersion>(engineVersions.length));
        }
        for (EngineVersion ele : engineVersions) {
            this.engineVersions.add(ele);
        }
        return this;
    }

    public BrokerEngineType withEngineVersions(Collection<EngineVersion> engineVersions) {
        this.setEngineVersions(engineVersions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEngineType() != null) {
            sb.append("EngineType: ").append(this.getEngineType()).append(",");
        }
        if (this.getEngineVersions() != null) {
            sb.append("EngineVersions: ").append(this.getEngineVersions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEngineType)) {
            return false;
        }
        BrokerEngineType other = (BrokerEngineType)obj;
        if (other.getEngineType() == null ^ this.getEngineType() == null) {
            return false;
        }
        if (other.getEngineType() != null && !other.getEngineType().equals(this.getEngineType())) {
            return false;
        }
        if (other.getEngineVersions() == null ^ this.getEngineVersions() == null) {
            return false;
        }
        return other.getEngineVersions() == null || other.getEngineVersions().equals(this.getEngineVersions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngineType() == null ? 0 : this.getEngineType().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersions() == null ? 0 : this.getEngineVersions().hashCode());
        return hashCode;
    }

    public BrokerEngineType clone() {
        try {
            return (BrokerEngineType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerEngineTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

