/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mq.model.BrokerEngineType;
import java.util.List;

@SdkInternalApi
public class BrokerEngineTypeMarshaller {
    private static final MarshallingInfo<String> ENGINETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineType").build();
    private static final MarshallingInfo<List> ENGINEVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("engineVersions").build();
    private static final BrokerEngineTypeMarshaller instance = new BrokerEngineTypeMarshaller();

    public static BrokerEngineTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(BrokerEngineType brokerEngineType, ProtocolMarshaller protocolMarshaller) {
        if (brokerEngineType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)brokerEngineType.getEngineType(), ENGINETYPE_BINDING);
            protocolMarshaller.marshall(brokerEngineType.getEngineVersions(), ENGINEVERSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

