/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.CrossClusterSearchConnectionProperties;
import com.amazonaws.services.opensearch.model.transform.ConnectionPropertiesMarshaller;
import java.io.Serializable;

public class ConnectionProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpoint;
    private CrossClusterSearchConnectionProperties crossClusterSearch;

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public ConnectionProperties withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setCrossClusterSearch(CrossClusterSearchConnectionProperties crossClusterSearch) {
        this.crossClusterSearch = crossClusterSearch;
    }

    public CrossClusterSearchConnectionProperties getCrossClusterSearch() {
        return this.crossClusterSearch;
    }

    public ConnectionProperties withCrossClusterSearch(CrossClusterSearchConnectionProperties crossClusterSearch) {
        this.setCrossClusterSearch(crossClusterSearch);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getCrossClusterSearch() != null) {
            sb.append("CrossClusterSearch: ").append(this.getCrossClusterSearch());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionProperties)) {
            return false;
        }
        ConnectionProperties other = (ConnectionProperties)obj;
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getCrossClusterSearch() == null ^ this.getCrossClusterSearch() == null) {
            return false;
        }
        return other.getCrossClusterSearch() == null || other.getCrossClusterSearch().equals(this.getCrossClusterSearch());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getCrossClusterSearch() == null ? 0 : this.getCrossClusterSearch().hashCode());
        return hashCode;
    }

    public ConnectionProperties clone() {
        try {
            return (ConnectionProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

