/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.ConnectionProperties;

@SdkInternalApi
public class ConnectionPropertiesMarshaller {
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").build();
    private static final MarshallingInfo<StructuredPojo> CROSSCLUSTERSEARCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrossClusterSearch").build();
    private static final ConnectionPropertiesMarshaller instance = new ConnectionPropertiesMarshaller();

    public static ConnectionPropertiesMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConnectionProperties connectionProperties, ProtocolMarshaller protocolMarshaller) {
        if (connectionProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)connectionProperties.getEndpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)connectionProperties.getCrossClusterSearch(), CROSSCLUSTERSEARCH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

