/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pcaconnectorad.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pcaconnectorad.model.PrivateKeyAttributesV3;
import java.util.List;

@SdkInternalApi
public class PrivateKeyAttributesV3Marshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").build();
    private static final MarshallingInfo<List> CRYPTOPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CryptoProviders").build();
    private static final MarshallingInfo<String> KEYSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySpec").build();
    private static final MarshallingInfo<StructuredPojo> KEYUSAGEPROPERTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyUsageProperty").build();
    private static final MarshallingInfo<Integer> MINIMALKEYLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinimalKeyLength").build();
    private static final PrivateKeyAttributesV3Marshaller instance = new PrivateKeyAttributesV3Marshaller();

    public static PrivateKeyAttributesV3Marshaller getInstance() {
        return instance;
    }

    public void marshall(PrivateKeyAttributesV3 privateKeyAttributesV3, ProtocolMarshaller protocolMarshaller) {
        if (privateKeyAttributesV3 == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)privateKeyAttributesV3.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall(privateKeyAttributesV3.getCryptoProviders(), CRYPTOPROVIDERS_BINDING);
            protocolMarshaller.marshall((Object)privateKeyAttributesV3.getKeySpec(), KEYSPEC_BINDING);
            protocolMarshaller.marshall((Object)privateKeyAttributesV3.getKeyUsageProperty(), KEYUSAGEPROPERTY_BINDING);
            protocolMarshaller.marshall((Object)privateKeyAttributesV3.getMinimalKeyLength(), MINIMALKEYLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

