/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.EndpointLocation;

@SdkInternalApi
public class EndpointLocationMarshaller {
    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<Double> LATITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Latitude").build();
    private static final MarshallingInfo<Double> LONGITUDE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Longitude").build();
    private static final MarshallingInfo<String> POSTALCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostalCode").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final EndpointLocationMarshaller instance = new EndpointLocationMarshaller();

    public static EndpointLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointLocation endpointLocation, ProtocolMarshaller protocolMarshaller) {
        if (endpointLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)endpointLocation.getCity(), CITY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.getLatitude(), LATITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.getLongitude(), LONGITUDE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.getPostalCode(), POSTALCODE_BINDING);
            protocolMarshaller.marshall((Object)endpointLocation.getRegion(), REGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

