/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pipes.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pipes.model.S3LogDestination;

@SdkInternalApi
public class S3LogDestinationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> BUCKETOWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketOwner").build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Prefix").build();
    private static final S3LogDestinationMarshaller instance = new S3LogDestinationMarshaller();

    public static S3LogDestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3LogDestination s3LogDestination, ProtocolMarshaller protocolMarshaller) {
        if (s3LogDestination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3LogDestination.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3LogDestination.getBucketOwner(), BUCKETOWNER_BINDING);
            protocolMarshaller.marshall((Object)s3LogDestination.getOutputFormat(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3LogDestination.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

