/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.quicksight.model.Ingestion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIngestionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Ingestion> ingestions;
    private String nextToken;
    private String requestId;
    private Integer status;

    public List<Ingestion> getIngestions() {
        return this.ingestions;
    }

    public void setIngestions(Collection<Ingestion> ingestions) {
        if (ingestions == null) {
            this.ingestions = null;
            return;
        }
        this.ingestions = new ArrayList<Ingestion>(ingestions);
    }

    public ListIngestionsResult withIngestions(Ingestion ... ingestions) {
        if (this.ingestions == null) {
            this.setIngestions(new ArrayList<Ingestion>(ingestions.length));
        }
        for (Ingestion ele : ingestions) {
            this.ingestions.add(ele);
        }
        return this;
    }

    public ListIngestionsResult withIngestions(Collection<Ingestion> ingestions) {
        this.setIngestions(ingestions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIngestionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public ListIngestionsResult withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public ListIngestionsResult withStatus(Integer status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIngestions() != null) {
            sb.append("Ingestions: ").append(this.getIngestions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionsResult)) {
            return false;
        }
        ListIngestionsResult other = (ListIngestionsResult)obj;
        if (other.getIngestions() == null ^ this.getIngestions() == null) {
            return false;
        }
        if (other.getIngestions() != null && !other.getIngestions().equals(this.getIngestions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIngestions() == null ? 0 : this.getIngestions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public ListIngestionsResult clone() {
        try {
            return (ListIngestionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

