/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.CalculatedColumn;
import com.amazonaws.services.quicksight.model.transform.CreateColumnsOperationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateColumnsOperation
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CalculatedColumn> columns;

    public List<CalculatedColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<CalculatedColumn> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<CalculatedColumn>(columns);
    }

    public CreateColumnsOperation withColumns(CalculatedColumn ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<CalculatedColumn>(columns.length));
        }
        for (CalculatedColumn ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public CreateColumnsOperation withColumns(Collection<CalculatedColumn> columns) {
        this.setColumns(columns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateColumnsOperation)) {
            return false;
        }
        CreateColumnsOperation other = (CreateColumnsOperation)obj;
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        return other.getColumns() == null || other.getColumns().equals(this.getColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        return hashCode;
    }

    public CreateColumnsOperation clone() {
        try {
            return (CreateColumnsOperation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateColumnsOperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

