/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.transform.FieldFolderMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldFolder
implements Serializable,
Cloneable,
StructuredPojo {
    private String description;
    private List<String> columns;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public FieldFolder withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<String> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<String>(columns);
    }

    public FieldFolder withColumns(String ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<String>(columns.length));
        }
        for (String ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public FieldFolder withColumns(Collection<String> columns) {
        this.setColumns(columns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldFolder)) {
            return false;
        }
        FieldFolder other = (FieldFolder)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        return other.getColumns() == null || other.getColumns().equals(this.getColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        return hashCode;
    }

    public FieldFolder clone() {
        try {
            return (FieldFolder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FieldFolderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

