/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.DataSetConfiguration;
import java.util.List;

@SdkInternalApi
public class DataSetConfigurationMarshaller {
    private static final MarshallingInfo<String> PLACEHOLDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Placeholder").build();
    private static final MarshallingInfo<StructuredPojo> DATASETSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSetSchema").build();
    private static final MarshallingInfo<List> COLUMNGROUPSCHEMALIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ColumnGroupSchemaList").build();
    private static final DataSetConfigurationMarshaller instance = new DataSetConfigurationMarshaller();

    public static DataSetConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSetConfiguration dataSetConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (dataSetConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataSetConfiguration.getPlaceholder(), PLACEHOLDER_BINDING);
            protocolMarshaller.marshall((Object)dataSetConfiguration.getDataSetSchema(), DATASETSCHEMA_BINDING);
            protocolMarshaller.marshall(dataSetConfiguration.getColumnGroupSchemaList(), COLUMNGROUPSCHEMALIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

