/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.FilterCondition;
import com.amazonaws.services.route53domains.model.SortCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDomainsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<FilterCondition> filterConditions;
    private SortCondition sortCondition;
    private String marker;
    private Integer maxItems;

    public List<FilterCondition> getFilterConditions() {
        if (this.filterConditions == null) {
            this.filterConditions = new SdkInternalList();
        }
        return this.filterConditions;
    }

    public void setFilterConditions(Collection<FilterCondition> filterConditions) {
        if (filterConditions == null) {
            this.filterConditions = null;
            return;
        }
        this.filterConditions = new SdkInternalList(filterConditions);
    }

    public ListDomainsRequest withFilterConditions(FilterCondition ... filterConditions) {
        if (this.filterConditions == null) {
            this.setFilterConditions((Collection<FilterCondition>)new SdkInternalList(filterConditions.length));
        }
        for (FilterCondition ele : filterConditions) {
            this.filterConditions.add((Object)ele);
        }
        return this;
    }

    public ListDomainsRequest withFilterConditions(Collection<FilterCondition> filterConditions) {
        this.setFilterConditions(filterConditions);
        return this;
    }

    public void setSortCondition(SortCondition sortCondition) {
        this.sortCondition = sortCondition;
    }

    public SortCondition getSortCondition() {
        return this.sortCondition;
    }

    public ListDomainsRequest withSortCondition(SortCondition sortCondition) {
        this.setSortCondition(sortCondition);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListDomainsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public ListDomainsRequest withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilterConditions() != null) {
            sb.append("FilterConditions: ").append(this.getFilterConditions()).append(",");
        }
        if (this.getSortCondition() != null) {
            sb.append("SortCondition: ").append(this.getSortCondition()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)obj;
        if (other.getFilterConditions() == null ^ this.getFilterConditions() == null) {
            return false;
        }
        if (other.getFilterConditions() != null && !other.getFilterConditions().equals(this.getFilterConditions())) {
            return false;
        }
        if (other.getSortCondition() == null ^ this.getSortCondition() == null) {
            return false;
        }
        if (other.getSortCondition() != null && !other.getSortCondition().equals(this.getSortCondition())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilterConditions() == null ? 0 : this.getFilterConditions().hashCode());
        hashCode = 31 * hashCode + (this.getSortCondition() == null ? 0 : this.getSortCondition().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public ListDomainsRequest clone() {
        return (ListDomainsRequest)super.clone();
    }
}

