/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.DomainPrice;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPricesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<DomainPrice> prices;
    private String nextPageMarker;

    public List<DomainPrice> getPrices() {
        if (this.prices == null) {
            this.prices = new SdkInternalList();
        }
        return this.prices;
    }

    public void setPrices(Collection<DomainPrice> prices) {
        if (prices == null) {
            this.prices = null;
            return;
        }
        this.prices = new SdkInternalList(prices);
    }

    public ListPricesResult withPrices(DomainPrice ... prices) {
        if (this.prices == null) {
            this.setPrices((Collection<DomainPrice>)new SdkInternalList(prices.length));
        }
        for (DomainPrice ele : prices) {
            this.prices.add((Object)ele);
        }
        return this;
    }

    public ListPricesResult withPrices(Collection<DomainPrice> prices) {
        this.setPrices(prices);
        return this;
    }

    public void setNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
    }

    public String getNextPageMarker() {
        return this.nextPageMarker;
    }

    public ListPricesResult withNextPageMarker(String nextPageMarker) {
        this.setNextPageMarker(nextPageMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrices() != null) {
            sb.append("Prices: ").append(this.getPrices()).append(",");
        }
        if (this.getNextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(this.getNextPageMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricesResult)) {
            return false;
        }
        ListPricesResult other = (ListPricesResult)obj;
        if (other.getPrices() == null ^ this.getPrices() == null) {
            return false;
        }
        if (other.getPrices() != null && !other.getPrices().equals(this.getPrices())) {
            return false;
        }
        if (other.getNextPageMarker() == null ^ this.getNextPageMarker() == null) {
            return false;
        }
        return other.getNextPageMarker() == null || other.getNextPageMarker().equals(this.getNextPageMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrices() == null ? 0 : this.getPrices().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageMarker() == null ? 0 : this.getNextPageMarker().hashCode());
        return hashCode;
    }

    public ListPricesResult clone() {
        try {
            return (ListPricesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

