/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.scheduler.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.scheduler.model.ScheduleGroupSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListScheduleGroupsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ScheduleGroupSummary> scheduleGroups;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListScheduleGroupsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ScheduleGroupSummary> getScheduleGroups() {
        return this.scheduleGroups;
    }

    public void setScheduleGroups(Collection<ScheduleGroupSummary> scheduleGroups) {
        if (scheduleGroups == null) {
            this.scheduleGroups = null;
            return;
        }
        this.scheduleGroups = new ArrayList<ScheduleGroupSummary>(scheduleGroups);
    }

    public ListScheduleGroupsResult withScheduleGroups(ScheduleGroupSummary ... scheduleGroups) {
        if (this.scheduleGroups == null) {
            this.setScheduleGroups(new ArrayList<ScheduleGroupSummary>(scheduleGroups.length));
        }
        for (ScheduleGroupSummary ele : scheduleGroups) {
            this.scheduleGroups.add(ele);
        }
        return this;
    }

    public ListScheduleGroupsResult withScheduleGroups(Collection<ScheduleGroupSummary> scheduleGroups) {
        this.setScheduleGroups(scheduleGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getScheduleGroups() != null) {
            sb.append("ScheduleGroups: ").append(this.getScheduleGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduleGroupsResult)) {
            return false;
        }
        ListScheduleGroupsResult other = (ListScheduleGroupsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getScheduleGroups() == null ^ this.getScheduleGroups() == null) {
            return false;
        }
        return other.getScheduleGroups() == null || other.getScheduleGroups().equals(this.getScheduleGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleGroups() == null ? 0 : this.getScheduleGroups().hashCode());
        return hashCode;
    }

    public ListScheduleGroupsResult clone() {
        try {
            return (ListScheduleGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

