/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Security Hub provides you with a comprehensive view of the security state of your AWS environment and resources. It
 * also provides you with the compliance status of your environment based on CIS AWS Foundations compliance checks.
 * Security Hub collects security data from AWS accounts, services, and integrated third-party products and helps you
 * analyze security trends in your environment to identify the highest priority security issues. For more information
 * about Security Hub, see the <i> <a
 * href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">AWS Security Hub User
 * Guide</a> </i>.
 * </p>
 * <p>
 * When you use operations in the Security Hub API, the requests are executed only in the AWS Region that is currently
 * active or in the specific AWS Region that you specify in your request. Any configuration or settings change that
 * results from the operation is applied only to that Region. To make the same change in other Regions, execute the same
 * command for each Region to apply the change to. For example, if your Region is set to <code>us-west-2</code>, when
 * you use <code>CreateMembers</code> to add a member account to Security Hub, the association of the member account
 * with the master account is created only in the us-west-2 Region. Security Hub must be enabled for the member account
 * in the same Region that the invite was sent from.
 * </p>
 * <p>
 * The following throttling limits apply to using Security Hub API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>GetFindings</code> - RateLimit of 3 requests per second, and a BurstLimit of 6 requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateFindings</code> - RateLimit of 1 request per second, and a BurstLimit of 5 requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * All other operations - RateLimit of 10 request per second, and a BurstLimit of 30 requests per second.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.securityhub;

