/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information about logs to be activated for the specified broker.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsAmazonMqBrokerLogsDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsAmazonMqBrokerLogsDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     */
    private Boolean audit;
    /**
     * <p>
     * Activates general logging.
     * </p>
     */
    private Boolean general;
    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     */
    private String auditLogGroup;
    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     */
    private String generalLogGroup;
    /**
     * <p>
     * The list of information about logs that are to be turned on for the specified broker.
     * </p>
     */
    private AwsAmazonMqBrokerLogsPendingDetails pending;

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     * 
     * @param audit
     *        Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
     *        logged. Doesn't apply to RabbitMQ brokers.
     */

    public void setAudit(Boolean audit) {
        this.audit = audit;
    }

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
     *         logged. Doesn't apply to RabbitMQ brokers.
     */

    public Boolean getAudit() {
        return this.audit;
    }

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     * 
     * @param audit
     *        Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
     *        logged. Doesn't apply to RabbitMQ brokers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsAmazonMqBrokerLogsDetails withAudit(Boolean audit) {
        setAudit(audit);
        return this;
    }

    /**
     * <p>
     * Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * Doesn't apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Activates audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
     *         logged. Doesn't apply to RabbitMQ brokers.
     */

    public Boolean isAudit() {
        return this.audit;
    }

    /**
     * <p>
     * Activates general logging.
     * </p>
     * 
     * @param general
     *        Activates general logging.
     */

    public void setGeneral(Boolean general) {
        this.general = general;
    }

    /**
     * <p>
     * Activates general logging.
     * </p>
     * 
     * @return Activates general logging.
     */

    public Boolean getGeneral() {
        return this.general;
    }

    /**
     * <p>
     * Activates general logging.
     * </p>
     * 
     * @param general
     *        Activates general logging.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsAmazonMqBrokerLogsDetails withGeneral(Boolean general) {
        setGeneral(general);
        return this;
    }

    /**
     * <p>
     * Activates general logging.
     * </p>
     * 
     * @return Activates general logging.
     */

    public Boolean isGeneral() {
        return this.general;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     * 
     * @param auditLogGroup
     *        The location of the CloudWatch Logs log group where audit logs are sent.
     */

    public void setAuditLogGroup(String auditLogGroup) {
        this.auditLogGroup = auditLogGroup;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where audit logs are sent.
     */

    public String getAuditLogGroup() {
        return this.auditLogGroup;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where audit logs are sent.
     * </p>
     * 
     * @param auditLogGroup
     *        The location of the CloudWatch Logs log group where audit logs are sent.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsAmazonMqBrokerLogsDetails withAuditLogGroup(String auditLogGroup) {
        setAuditLogGroup(auditLogGroup);
        return this;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     * 
     * @param generalLogGroup
     *        The location of the CloudWatch Logs log group where general logs are sent.
     */

    public void setGeneralLogGroup(String generalLogGroup) {
        this.generalLogGroup = generalLogGroup;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     * 
     * @return The location of the CloudWatch Logs log group where general logs are sent.
     */

    public String getGeneralLogGroup() {
        return this.generalLogGroup;
    }

    /**
     * <p>
     * The location of the CloudWatch Logs log group where general logs are sent.
     * </p>
     * 
     * @param generalLogGroup
     *        The location of the CloudWatch Logs log group where general logs are sent.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsAmazonMqBrokerLogsDetails withGeneralLogGroup(String generalLogGroup) {
        setGeneralLogGroup(generalLogGroup);
        return this;
    }

    /**
     * <p>
     * The list of information about logs that are to be turned on for the specified broker.
     * </p>
     * 
     * @param pending
     *        The list of information about logs that are to be turned on for the specified broker.
     */

    public void setPending(AwsAmazonMqBrokerLogsPendingDetails pending) {
        this.pending = pending;
    }

    /**
     * <p>
     * The list of information about logs that are to be turned on for the specified broker.
     * </p>
     * 
     * @return The list of information about logs that are to be turned on for the specified broker.
     */

    public AwsAmazonMqBrokerLogsPendingDetails getPending() {
        return this.pending;
    }

    /**
     * <p>
     * The list of information about logs that are to be turned on for the specified broker.
     * </p>
     * 
     * @param pending
     *        The list of information about logs that are to be turned on for the specified broker.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsAmazonMqBrokerLogsDetails withPending(AwsAmazonMqBrokerLogsPendingDetails pending) {
        setPending(pending);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAudit() != null)
            sb.append("Audit: ").append(getAudit()).append(",");
        if (getGeneral() != null)
            sb.append("General: ").append(getGeneral()).append(",");
        if (getAuditLogGroup() != null)
            sb.append("AuditLogGroup: ").append(getAuditLogGroup()).append(",");
        if (getGeneralLogGroup() != null)
            sb.append("GeneralLogGroup: ").append(getGeneralLogGroup()).append(",");
        if (getPending() != null)
            sb.append("Pending: ").append(getPending());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsAmazonMqBrokerLogsDetails == false)
            return false;
        AwsAmazonMqBrokerLogsDetails other = (AwsAmazonMqBrokerLogsDetails) obj;
        if (other.getAudit() == null ^ this.getAudit() == null)
            return false;
        if (other.getAudit() != null && other.getAudit().equals(this.getAudit()) == false)
            return false;
        if (other.getGeneral() == null ^ this.getGeneral() == null)
            return false;
        if (other.getGeneral() != null && other.getGeneral().equals(this.getGeneral()) == false)
            return false;
        if (other.getAuditLogGroup() == null ^ this.getAuditLogGroup() == null)
            return false;
        if (other.getAuditLogGroup() != null && other.getAuditLogGroup().equals(this.getAuditLogGroup()) == false)
            return false;
        if (other.getGeneralLogGroup() == null ^ this.getGeneralLogGroup() == null)
            return false;
        if (other.getGeneralLogGroup() != null && other.getGeneralLogGroup().equals(this.getGeneralLogGroup()) == false)
            return false;
        if (other.getPending() == null ^ this.getPending() == null)
            return false;
        if (other.getPending() != null && other.getPending().equals(this.getPending()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAudit() == null) ? 0 : getAudit().hashCode());
        hashCode = prime * hashCode + ((getGeneral() == null) ? 0 : getGeneral().hashCode());
        hashCode = prime * hashCode + ((getAuditLogGroup() == null) ? 0 : getAuditLogGroup().hashCode());
        hashCode = prime * hashCode + ((getGeneralLogGroup() == null) ? 0 : getGeneralLogGroup().hashCode());
        hashCode = prime * hashCode + ((getPending() == null) ? 0 : getPending().hashCode());
        return hashCode;
    }

    @Override
    public AwsAmazonMqBrokerLogsDetails clone() {
        try {
            return (AwsAmazonMqBrokerLogsDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsAmazonMqBrokerLogsDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
