/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.securityhub.model.SecurityControl;
import com.amazonaws.services.securityhub.model.UnprocessedSecurityControl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetSecurityControlsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SecurityControl> securityControls;
    private List<UnprocessedSecurityControl> unprocessedIds;

    public List<SecurityControl> getSecurityControls() {
        return this.securityControls;
    }

    public void setSecurityControls(Collection<SecurityControl> securityControls) {
        if (securityControls == null) {
            this.securityControls = null;
            return;
        }
        this.securityControls = new ArrayList<SecurityControl>(securityControls);
    }

    public BatchGetSecurityControlsResult withSecurityControls(SecurityControl ... securityControls) {
        if (this.securityControls == null) {
            this.setSecurityControls(new ArrayList<SecurityControl>(securityControls.length));
        }
        for (SecurityControl ele : securityControls) {
            this.securityControls.add(ele);
        }
        return this;
    }

    public BatchGetSecurityControlsResult withSecurityControls(Collection<SecurityControl> securityControls) {
        this.setSecurityControls(securityControls);
        return this;
    }

    public List<UnprocessedSecurityControl> getUnprocessedIds() {
        return this.unprocessedIds;
    }

    public void setUnprocessedIds(Collection<UnprocessedSecurityControl> unprocessedIds) {
        if (unprocessedIds == null) {
            this.unprocessedIds = null;
            return;
        }
        this.unprocessedIds = new ArrayList<UnprocessedSecurityControl>(unprocessedIds);
    }

    public BatchGetSecurityControlsResult withUnprocessedIds(UnprocessedSecurityControl ... unprocessedIds) {
        if (this.unprocessedIds == null) {
            this.setUnprocessedIds(new ArrayList<UnprocessedSecurityControl>(unprocessedIds.length));
        }
        for (UnprocessedSecurityControl ele : unprocessedIds) {
            this.unprocessedIds.add(ele);
        }
        return this;
    }

    public BatchGetSecurityControlsResult withUnprocessedIds(Collection<UnprocessedSecurityControl> unprocessedIds) {
        this.setUnprocessedIds(unprocessedIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityControls() != null) {
            sb.append("SecurityControls: ").append(this.getSecurityControls()).append(",");
        }
        if (this.getUnprocessedIds() != null) {
            sb.append("UnprocessedIds: ").append(this.getUnprocessedIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecurityControlsResult)) {
            return false;
        }
        BatchGetSecurityControlsResult other = (BatchGetSecurityControlsResult)obj;
        if (other.getSecurityControls() == null ^ this.getSecurityControls() == null) {
            return false;
        }
        if (other.getSecurityControls() != null && !other.getSecurityControls().equals(this.getSecurityControls())) {
            return false;
        }
        if (other.getUnprocessedIds() == null ^ this.getUnprocessedIds() == null) {
            return false;
        }
        return other.getUnprocessedIds() == null || other.getUnprocessedIds().equals(this.getUnprocessedIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityControls() == null ? 0 : this.getSecurityControls().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedIds() == null ? 0 : this.getUnprocessedIds().hashCode());
        return hashCode;
    }

    public BatchGetSecurityControlsResult clone() {
        try {
            return (BatchGetSecurityControlsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

