/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.ParameterDefinition;
import com.amazonaws.services.securityhub.model.RegionAvailabilityStatus;
import com.amazonaws.services.securityhub.model.SecurityControlProperty;
import com.amazonaws.services.securityhub.model.SeverityRating;
import com.amazonaws.services.securityhub.model.transform.SecurityControlDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityControlDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String securityControlId;
    private String title;
    private String description;
    private String remediationUrl;
    private String severityRating;
    private String currentRegionAvailability;
    private List<String> customizableProperties;
    private Map<String, ParameterDefinition> parameterDefinitions;

    public void setSecurityControlId(String securityControlId) {
        this.securityControlId = securityControlId;
    }

    public String getSecurityControlId() {
        return this.securityControlId;
    }

    public SecurityControlDefinition withSecurityControlId(String securityControlId) {
        this.setSecurityControlId(securityControlId);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public SecurityControlDefinition withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityControlDefinition withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRemediationUrl(String remediationUrl) {
        this.remediationUrl = remediationUrl;
    }

    public String getRemediationUrl() {
        return this.remediationUrl;
    }

    public SecurityControlDefinition withRemediationUrl(String remediationUrl) {
        this.setRemediationUrl(remediationUrl);
        return this;
    }

    public void setSeverityRating(String severityRating) {
        this.severityRating = severityRating;
    }

    public String getSeverityRating() {
        return this.severityRating;
    }

    public SecurityControlDefinition withSeverityRating(String severityRating) {
        this.setSeverityRating(severityRating);
        return this;
    }

    public SecurityControlDefinition withSeverityRating(SeverityRating severityRating) {
        this.severityRating = severityRating.toString();
        return this;
    }

    public void setCurrentRegionAvailability(String currentRegionAvailability) {
        this.currentRegionAvailability = currentRegionAvailability;
    }

    public String getCurrentRegionAvailability() {
        return this.currentRegionAvailability;
    }

    public SecurityControlDefinition withCurrentRegionAvailability(String currentRegionAvailability) {
        this.setCurrentRegionAvailability(currentRegionAvailability);
        return this;
    }

    public SecurityControlDefinition withCurrentRegionAvailability(RegionAvailabilityStatus currentRegionAvailability) {
        this.currentRegionAvailability = currentRegionAvailability.toString();
        return this;
    }

    public List<String> getCustomizableProperties() {
        return this.customizableProperties;
    }

    public void setCustomizableProperties(Collection<String> customizableProperties) {
        if (customizableProperties == null) {
            this.customizableProperties = null;
            return;
        }
        this.customizableProperties = new ArrayList<String>(customizableProperties);
    }

    public SecurityControlDefinition withCustomizableProperties(String ... customizableProperties) {
        if (this.customizableProperties == null) {
            this.setCustomizableProperties(new ArrayList<String>(customizableProperties.length));
        }
        for (String ele : customizableProperties) {
            this.customizableProperties.add(ele);
        }
        return this;
    }

    public SecurityControlDefinition withCustomizableProperties(Collection<String> customizableProperties) {
        this.setCustomizableProperties(customizableProperties);
        return this;
    }

    public SecurityControlDefinition withCustomizableProperties(SecurityControlProperty ... customizableProperties) {
        ArrayList<String> customizablePropertiesCopy = new ArrayList<String>(customizableProperties.length);
        for (SecurityControlProperty value : customizableProperties) {
            customizablePropertiesCopy.add(value.toString());
        }
        if (this.getCustomizableProperties() == null) {
            this.setCustomizableProperties(customizablePropertiesCopy);
        } else {
            this.getCustomizableProperties().addAll(customizablePropertiesCopy);
        }
        return this;
    }

    public Map<String, ParameterDefinition> getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setParameterDefinitions(Map<String, ParameterDefinition> parameterDefinitions) {
        this.parameterDefinitions = parameterDefinitions;
    }

    public SecurityControlDefinition withParameterDefinitions(Map<String, ParameterDefinition> parameterDefinitions) {
        this.setParameterDefinitions(parameterDefinitions);
        return this;
    }

    public SecurityControlDefinition addParameterDefinitionsEntry(String key, ParameterDefinition value) {
        if (null == this.parameterDefinitions) {
            this.parameterDefinitions = new HashMap<String, ParameterDefinition>();
        }
        if (this.parameterDefinitions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameterDefinitions.put(key, value);
        return this;
    }

    public SecurityControlDefinition clearParameterDefinitionsEntries() {
        this.parameterDefinitions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityControlId() != null) {
            sb.append("SecurityControlId: ").append(this.getSecurityControlId()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRemediationUrl() != null) {
            sb.append("RemediationUrl: ").append(this.getRemediationUrl()).append(",");
        }
        if (this.getSeverityRating() != null) {
            sb.append("SeverityRating: ").append(this.getSeverityRating()).append(",");
        }
        if (this.getCurrentRegionAvailability() != null) {
            sb.append("CurrentRegionAvailability: ").append(this.getCurrentRegionAvailability()).append(",");
        }
        if (this.getCustomizableProperties() != null) {
            sb.append("CustomizableProperties: ").append(this.getCustomizableProperties()).append(",");
        }
        if (this.getParameterDefinitions() != null) {
            sb.append("ParameterDefinitions: ").append(this.getParameterDefinitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlDefinition)) {
            return false;
        }
        SecurityControlDefinition other = (SecurityControlDefinition)obj;
        if (other.getSecurityControlId() == null ^ this.getSecurityControlId() == null) {
            return false;
        }
        if (other.getSecurityControlId() != null && !other.getSecurityControlId().equals(this.getSecurityControlId())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRemediationUrl() == null ^ this.getRemediationUrl() == null) {
            return false;
        }
        if (other.getRemediationUrl() != null && !other.getRemediationUrl().equals(this.getRemediationUrl())) {
            return false;
        }
        if (other.getSeverityRating() == null ^ this.getSeverityRating() == null) {
            return false;
        }
        if (other.getSeverityRating() != null && !other.getSeverityRating().equals(this.getSeverityRating())) {
            return false;
        }
        if (other.getCurrentRegionAvailability() == null ^ this.getCurrentRegionAvailability() == null) {
            return false;
        }
        if (other.getCurrentRegionAvailability() != null && !other.getCurrentRegionAvailability().equals(this.getCurrentRegionAvailability())) {
            return false;
        }
        if (other.getCustomizableProperties() == null ^ this.getCustomizableProperties() == null) {
            return false;
        }
        if (other.getCustomizableProperties() != null && !other.getCustomizableProperties().equals(this.getCustomizableProperties())) {
            return false;
        }
        if (other.getParameterDefinitions() == null ^ this.getParameterDefinitions() == null) {
            return false;
        }
        return other.getParameterDefinitions() == null || other.getParameterDefinitions().equals(this.getParameterDefinitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityControlId() == null ? 0 : this.getSecurityControlId().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRemediationUrl() == null ? 0 : this.getRemediationUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSeverityRating() == null ? 0 : this.getSeverityRating().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentRegionAvailability() == null ? 0 : this.getCurrentRegionAvailability().hashCode());
        hashCode = 31 * hashCode + (this.getCustomizableProperties() == null ? 0 : this.getCustomizableProperties().hashCode());
        hashCode = 31 * hashCode + (this.getParameterDefinitions() == null ? 0 : this.getParameterDefinitions().hashCode());
        return hashCode;
    }

    public SecurityControlDefinition clone() {
        try {
            return (SecurityControlDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityControlDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

