/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.ApplicationCredential;
import com.amazonaws.services.ssmsap.model.DatabaseStatus;
import com.amazonaws.services.ssmsap.model.DatabaseType;
import com.amazonaws.services.ssmsap.model.transform.DatabaseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Database
implements Serializable,
Cloneable,
StructuredPojo {
    private String applicationId;
    private String componentId;
    private List<ApplicationCredential> credentials;
    private String databaseId;
    private String databaseName;
    private String databaseType;
    private String arn;
    private String status;
    private String primaryHost;
    private Integer sQLPort;
    private Date lastUpdated;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Database withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Database withComponentId(String componentId) {
        this.setComponentId(componentId);
        return this;
    }

    public List<ApplicationCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Collection<ApplicationCredential> credentials) {
        if (credentials == null) {
            this.credentials = null;
            return;
        }
        this.credentials = new ArrayList<ApplicationCredential>(credentials);
    }

    public Database withCredentials(ApplicationCredential ... credentials) {
        if (this.credentials == null) {
            this.setCredentials(new ArrayList<ApplicationCredential>(credentials.length));
        }
        for (ApplicationCredential ele : credentials) {
            this.credentials.add(ele);
        }
        return this;
    }

    public Database withCredentials(Collection<ApplicationCredential> credentials) {
        this.setCredentials(credentials);
        return this;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public Database withDatabaseId(String databaseId) {
        this.setDatabaseId(databaseId);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Database withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Database withDatabaseType(String databaseType) {
        this.setDatabaseType(databaseType);
        return this;
    }

    public Database withDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Database withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Database withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Database withStatus(DatabaseStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setPrimaryHost(String primaryHost) {
        this.primaryHost = primaryHost;
    }

    public String getPrimaryHost() {
        return this.primaryHost;
    }

    public Database withPrimaryHost(String primaryHost) {
        this.setPrimaryHost(primaryHost);
        return this;
    }

    public void setSQLPort(Integer sQLPort) {
        this.sQLPort = sQLPort;
    }

    public Integer getSQLPort() {
        return this.sQLPort;
    }

    public Database withSQLPort(Integer sQLPort) {
        this.setSQLPort(sQLPort);
        return this;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Database withLastUpdated(Date lastUpdated) {
        this.setLastUpdated(lastUpdated);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getComponentId() != null) {
            sb.append("ComponentId: ").append(this.getComponentId()).append(",");
        }
        if (this.getCredentials() != null) {
            sb.append("Credentials: ").append(this.getCredentials()).append(",");
        }
        if (this.getDatabaseId() != null) {
            sb.append("DatabaseId: ").append(this.getDatabaseId()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getDatabaseType() != null) {
            sb.append("DatabaseType: ").append(this.getDatabaseType()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getPrimaryHost() != null) {
            sb.append("PrimaryHost: ").append(this.getPrimaryHost()).append(",");
        }
        if (this.getSQLPort() != null) {
            sb.append("SQLPort: ").append(this.getSQLPort()).append(",");
        }
        if (this.getLastUpdated() != null) {
            sb.append("LastUpdated: ").append(this.getLastUpdated());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Database)) {
            return false;
        }
        Database other = (Database)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getComponentId() == null ^ this.getComponentId() == null) {
            return false;
        }
        if (other.getComponentId() != null && !other.getComponentId().equals(this.getComponentId())) {
            return false;
        }
        if (other.getCredentials() == null ^ this.getCredentials() == null) {
            return false;
        }
        if (other.getCredentials() != null && !other.getCredentials().equals(this.getCredentials())) {
            return false;
        }
        if (other.getDatabaseId() == null ^ this.getDatabaseId() == null) {
            return false;
        }
        if (other.getDatabaseId() != null && !other.getDatabaseId().equals(this.getDatabaseId())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getDatabaseType() == null ^ this.getDatabaseType() == null) {
            return false;
        }
        if (other.getDatabaseType() != null && !other.getDatabaseType().equals(this.getDatabaseType())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPrimaryHost() == null ^ this.getPrimaryHost() == null) {
            return false;
        }
        if (other.getPrimaryHost() != null && !other.getPrimaryHost().equals(this.getPrimaryHost())) {
            return false;
        }
        if (other.getSQLPort() == null ^ this.getSQLPort() == null) {
            return false;
        }
        if (other.getSQLPort() != null && !other.getSQLPort().equals(this.getSQLPort())) {
            return false;
        }
        if (other.getLastUpdated() == null ^ this.getLastUpdated() == null) {
            return false;
        }
        return other.getLastUpdated() == null || other.getLastUpdated().equals(this.getLastUpdated());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getComponentId() == null ? 0 : this.getComponentId().hashCode());
        hashCode = 31 * hashCode + (this.getCredentials() == null ? 0 : this.getCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseId() == null ? 0 : this.getDatabaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseType() == null ? 0 : this.getDatabaseType().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryHost() == null ? 0 : this.getPrimaryHost().hashCode());
        hashCode = 31 * hashCode + (this.getSQLPort() == null ? 0 : this.getSQLPort().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdated() == null ? 0 : this.getLastUpdated().hashCode());
        return hashCode;
    }

    public Database clone() {
        try {
            return (Database)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatabaseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

