/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.translate.model.ParallelDataFormat;
import com.amazonaws.services.translate.model.transform.ParallelDataConfigMarshaller;
import java.io.Serializable;

public class ParallelDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Uri;
    private String format;

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public ParallelDataConfig withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public ParallelDataConfig withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public ParallelDataConfig withFormat(ParallelDataFormat format) {
        this.format = format.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelDataConfig)) {
            return false;
        }
        ParallelDataConfig other = (ParallelDataConfig)obj;
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        if (other.getS3Uri() != null && !other.getS3Uri().equals(this.getS3Uri())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        return other.getFormat() == null || other.getFormat().equals(this.getFormat());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        return hashCode;
    }

    public ParallelDataConfig clone() {
        try {
            return (ParallelDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParallelDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

