/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.translate.model.Document;
import java.nio.ByteBuffer;

@SdkInternalApi
public class DocumentMarshaller {
    private static final MarshallingInfo<ByteBuffer> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").build();
    private static final DocumentMarshaller instance = new DocumentMarshaller();

    public static DocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Document document, ProtocolMarshaller protocolMarshaller) {
        if (document == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)document.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)document.getContentType(), CONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

