/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class MSKFirehoseEvent {
    private String invocationId;
    private String deliveryStreamArn;
    private String sourceMSKArn;
    private String region;
    private List<Record> records;

    public static MSKFirehoseEventBuilder builder() {
        return new MSKFirehoseEventBuilder();
    }

    public String getInvocationId() {
        return this.invocationId;
    }

    public String getDeliveryStreamArn() {
        return this.deliveryStreamArn;
    }

    public String getSourceMSKArn() {
        return this.sourceMSKArn;
    }

    public String getRegion() {
        return this.region;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setInvocationId(String invocationId) {
        this.invocationId = invocationId;
    }

    public void setDeliveryStreamArn(String deliveryStreamArn) {
        this.deliveryStreamArn = deliveryStreamArn;
    }

    public void setSourceMSKArn(String sourceMSKArn) {
        this.sourceMSKArn = sourceMSKArn;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MSKFirehoseEvent)) {
            return false;
        }
        MSKFirehoseEvent other = (MSKFirehoseEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$invocationId = this.getInvocationId();
        String other$invocationId = other.getInvocationId();
        if (this$invocationId == null ? other$invocationId != null : !this$invocationId.equals(other$invocationId)) {
            return false;
        }
        String this$deliveryStreamArn = this.getDeliveryStreamArn();
        String other$deliveryStreamArn = other.getDeliveryStreamArn();
        if (this$deliveryStreamArn == null ? other$deliveryStreamArn != null : !this$deliveryStreamArn.equals(other$deliveryStreamArn)) {
            return false;
        }
        String this$sourceMSKArn = this.getSourceMSKArn();
        String other$sourceMSKArn = other.getSourceMSKArn();
        if (this$sourceMSKArn == null ? other$sourceMSKArn != null : !this$sourceMSKArn.equals(other$sourceMSKArn)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        List<Record> this$records = this.getRecords();
        List<Record> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MSKFirehoseEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $invocationId = this.getInvocationId();
        result = result * 59 + ($invocationId == null ? 43 : $invocationId.hashCode());
        String $deliveryStreamArn = this.getDeliveryStreamArn();
        result = result * 59 + ($deliveryStreamArn == null ? 43 : $deliveryStreamArn.hashCode());
        String $sourceMSKArn = this.getSourceMSKArn();
        result = result * 59 + ($sourceMSKArn == null ? 43 : $sourceMSKArn.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        List<Record> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public String toString() {
        return "MSKFirehoseEvent(invocationId=" + this.getInvocationId() + ", deliveryStreamArn=" + this.getDeliveryStreamArn() + ", sourceMSKArn=" + this.getSourceMSKArn() + ", region=" + this.getRegion() + ", records=" + this.getRecords() + ")";
    }

    public MSKFirehoseEvent() {
    }

    public MSKFirehoseEvent(String invocationId, String deliveryStreamArn, String sourceMSKArn, String region, List<Record> records) {
        this.invocationId = invocationId;
        this.deliveryStreamArn = deliveryStreamArn;
        this.sourceMSKArn = sourceMSKArn;
        this.region = region;
        this.records = records;
    }

    public static class MSKFirehoseEventBuilder {
        private String invocationId;
        private String deliveryStreamArn;
        private String sourceMSKArn;
        private String region;
        private List<Record> records;

        MSKFirehoseEventBuilder() {
        }

        public MSKFirehoseEventBuilder withInvocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public MSKFirehoseEventBuilder withDeliveryStreamArn(String deliveryStreamArn) {
            this.deliveryStreamArn = deliveryStreamArn;
            return this;
        }

        public MSKFirehoseEventBuilder withSourceMSKArn(String sourceMSKArn) {
            this.sourceMSKArn = sourceMSKArn;
            return this;
        }

        public MSKFirehoseEventBuilder withRegion(String region) {
            this.region = region;
            return this;
        }

        public MSKFirehoseEventBuilder withRecords(List<Record> records) {
            this.records = records;
            return this;
        }

        public MSKFirehoseEvent build() {
            return new MSKFirehoseEvent(this.invocationId, this.deliveryStreamArn, this.sourceMSKArn, this.region, this.records);
        }

        public String toString() {
            return "MSKFirehoseEvent.MSKFirehoseEventBuilder(invocationId=" + this.invocationId + ", deliveryStreamArn=" + this.deliveryStreamArn + ", sourceMSKArn=" + this.sourceMSKArn + ", region=" + this.region + ", records=" + this.records + ")";
        }
    }

    public static class Record {
        private ByteBuffer kafkaRecordValue;
        private String recordId;
        private Long approximateArrivalEpoch;
        private Long approximateArrivalTimestamp;
        private Map<String, String> mskRecordMetadata;

        public static RecordBuilder builder() {
            return new RecordBuilder();
        }

        public ByteBuffer getKafkaRecordValue() {
            return this.kafkaRecordValue;
        }

        public String getRecordId() {
            return this.recordId;
        }

        public Long getApproximateArrivalEpoch() {
            return this.approximateArrivalEpoch;
        }

        public Long getApproximateArrivalTimestamp() {
            return this.approximateArrivalTimestamp;
        }

        public Map<String, String> getMskRecordMetadata() {
            return this.mskRecordMetadata;
        }

        public void setKafkaRecordValue(ByteBuffer kafkaRecordValue) {
            this.kafkaRecordValue = kafkaRecordValue;
        }

        public void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        public void setApproximateArrivalEpoch(Long approximateArrivalEpoch) {
            this.approximateArrivalEpoch = approximateArrivalEpoch;
        }

        public void setApproximateArrivalTimestamp(Long approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        }

        public void setMskRecordMetadata(Map<String, String> mskRecordMetadata) {
            this.mskRecordMetadata = mskRecordMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record other = (Record)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$approximateArrivalEpoch = this.getApproximateArrivalEpoch();
            Long other$approximateArrivalEpoch = other.getApproximateArrivalEpoch();
            if (this$approximateArrivalEpoch == null ? other$approximateArrivalEpoch != null : !((Object)this$approximateArrivalEpoch).equals(other$approximateArrivalEpoch)) {
                return false;
            }
            Long this$approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
            Long other$approximateArrivalTimestamp = other.getApproximateArrivalTimestamp();
            if (this$approximateArrivalTimestamp == null ? other$approximateArrivalTimestamp != null : !((Object)this$approximateArrivalTimestamp).equals(other$approximateArrivalTimestamp)) {
                return false;
            }
            ByteBuffer this$kafkaRecordValue = this.getKafkaRecordValue();
            ByteBuffer other$kafkaRecordValue = other.getKafkaRecordValue();
            if (this$kafkaRecordValue == null ? other$kafkaRecordValue != null : !((Object)this$kafkaRecordValue).equals(other$kafkaRecordValue)) {
                return false;
            }
            String this$recordId = this.getRecordId();
            String other$recordId = other.getRecordId();
            if (this$recordId == null ? other$recordId != null : !this$recordId.equals(other$recordId)) {
                return false;
            }
            Map<String, String> this$mskRecordMetadata = this.getMskRecordMetadata();
            Map<String, String> other$mskRecordMetadata = other.getMskRecordMetadata();
            return !(this$mskRecordMetadata == null ? other$mskRecordMetadata != null : !((Object)this$mskRecordMetadata).equals(other$mskRecordMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Record;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $approximateArrivalEpoch = this.getApproximateArrivalEpoch();
            result = result * 59 + ($approximateArrivalEpoch == null ? 43 : ((Object)$approximateArrivalEpoch).hashCode());
            Long $approximateArrivalTimestamp = this.getApproximateArrivalTimestamp();
            result = result * 59 + ($approximateArrivalTimestamp == null ? 43 : ((Object)$approximateArrivalTimestamp).hashCode());
            ByteBuffer $kafkaRecordValue = this.getKafkaRecordValue();
            result = result * 59 + ($kafkaRecordValue == null ? 43 : ((Object)$kafkaRecordValue).hashCode());
            String $recordId = this.getRecordId();
            result = result * 59 + ($recordId == null ? 43 : $recordId.hashCode());
            Map<String, String> $mskRecordMetadata = this.getMskRecordMetadata();
            result = result * 59 + ($mskRecordMetadata == null ? 43 : ((Object)$mskRecordMetadata).hashCode());
            return result;
        }

        public String toString() {
            return "MSKFirehoseEvent.Record(kafkaRecordValue=" + this.getKafkaRecordValue() + ", recordId=" + this.getRecordId() + ", approximateArrivalEpoch=" + this.getApproximateArrivalEpoch() + ", approximateArrivalTimestamp=" + this.getApproximateArrivalTimestamp() + ", mskRecordMetadata=" + this.getMskRecordMetadata() + ")";
        }

        public Record() {
        }

        public Record(ByteBuffer kafkaRecordValue, String recordId, Long approximateArrivalEpoch, Long approximateArrivalTimestamp, Map<String, String> mskRecordMetadata) {
            this.kafkaRecordValue = kafkaRecordValue;
            this.recordId = recordId;
            this.approximateArrivalEpoch = approximateArrivalEpoch;
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            this.mskRecordMetadata = mskRecordMetadata;
        }

        public static class RecordBuilder {
            private ByteBuffer kafkaRecordValue;
            private String recordId;
            private Long approximateArrivalEpoch;
            private Long approximateArrivalTimestamp;
            private Map<String, String> mskRecordMetadata;

            RecordBuilder() {
            }

            public RecordBuilder withKafkaRecordValue(ByteBuffer kafkaRecordValue) {
                this.kafkaRecordValue = kafkaRecordValue;
                return this;
            }

            public RecordBuilder withRecordId(String recordId) {
                this.recordId = recordId;
                return this;
            }

            public RecordBuilder withApproximateArrivalEpoch(Long approximateArrivalEpoch) {
                this.approximateArrivalEpoch = approximateArrivalEpoch;
                return this;
            }

            public RecordBuilder withApproximateArrivalTimestamp(Long approximateArrivalTimestamp) {
                this.approximateArrivalTimestamp = approximateArrivalTimestamp;
                return this;
            }

            public RecordBuilder withMskRecordMetadata(Map<String, String> mskRecordMetadata) {
                this.mskRecordMetadata = mskRecordMetadata;
                return this;
            }

            public Record build() {
                return new Record(this.kafkaRecordValue, this.recordId, this.approximateArrivalEpoch, this.approximateArrivalTimestamp, this.mskRecordMetadata);
            }

            public String toString() {
                return "MSKFirehoseEvent.Record.RecordBuilder(kafkaRecordValue=" + this.kafkaRecordValue + ", recordId=" + this.recordId + ", approximateArrivalEpoch=" + this.approximateArrivalEpoch + ", approximateArrivalTimestamp=" + this.approximateArrivalTimestamp + ", mskRecordMetadata=" + this.mskRecordMetadata + ")";
            }
        }
    }
}

