/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events;

import com.amazonaws.services.lambda.runtime.events.DynamodbEvent;
import com.amazonaws.services.lambda.runtime.events.models.TimeWindow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DynamodbTimeWindowEvent
extends DynamodbEvent
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5449871161108629510L;
    private TimeWindow window;
    private Map<String, String> state;
    private String shardId;
    private String eventSourceArn;
    private Boolean isFinalInvokeForWindow;
    private Boolean isWindowTerminatedEarly;

    public DynamodbTimeWindowEvent(List<DynamodbEvent.DynamodbStreamRecord> records, TimeWindow window, Map<String, String> state, String shardId, String eventSourceArn, Boolean isFinalInvokeForWindow, Boolean isWindowTerminatedEarly) {
        this.setRecords(records);
        this.window = window;
        this.state = state;
        this.shardId = shardId;
        this.eventSourceArn = eventSourceArn;
        this.isFinalInvokeForWindow = isFinalInvokeForWindow;
        this.isWindowTerminatedEarly = isWindowTerminatedEarly;
    }

    public static DynamodbTimeWindowEventBuilder builder() {
        return new DynamodbTimeWindowEventBuilder();
    }

    public TimeWindow getWindow() {
        return this.window;
    }

    public Map<String, String> getState() {
        return this.state;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getEventSourceArn() {
        return this.eventSourceArn;
    }

    public Boolean getIsFinalInvokeForWindow() {
        return this.isFinalInvokeForWindow;
    }

    public Boolean getIsWindowTerminatedEarly() {
        return this.isWindowTerminatedEarly;
    }

    public void setWindow(TimeWindow window) {
        this.window = window;
    }

    public void setState(Map<String, String> state) {
        this.state = state;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public void setEventSourceArn(String eventSourceArn) {
        this.eventSourceArn = eventSourceArn;
    }

    public void setIsFinalInvokeForWindow(Boolean isFinalInvokeForWindow) {
        this.isFinalInvokeForWindow = isFinalInvokeForWindow;
    }

    public void setIsWindowTerminatedEarly(Boolean isWindowTerminatedEarly) {
        this.isWindowTerminatedEarly = isWindowTerminatedEarly;
    }

    @Override
    public String toString() {
        return "DynamodbTimeWindowEvent(window=" + this.getWindow() + ", state=" + this.getState() + ", shardId=" + this.getShardId() + ", eventSourceArn=" + this.getEventSourceArn() + ", isFinalInvokeForWindow=" + this.getIsFinalInvokeForWindow() + ", isWindowTerminatedEarly=" + this.getIsWindowTerminatedEarly() + ")";
    }

    public DynamodbTimeWindowEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamodbTimeWindowEvent)) {
            return false;
        }
        DynamodbTimeWindowEvent other = (DynamodbTimeWindowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isFinalInvokeForWindow = this.getIsFinalInvokeForWindow();
        Boolean other$isFinalInvokeForWindow = other.getIsFinalInvokeForWindow();
        if (this$isFinalInvokeForWindow == null ? other$isFinalInvokeForWindow != null : !((Object)this$isFinalInvokeForWindow).equals(other$isFinalInvokeForWindow)) {
            return false;
        }
        Boolean this$isWindowTerminatedEarly = this.getIsWindowTerminatedEarly();
        Boolean other$isWindowTerminatedEarly = other.getIsWindowTerminatedEarly();
        if (this$isWindowTerminatedEarly == null ? other$isWindowTerminatedEarly != null : !((Object)this$isWindowTerminatedEarly).equals(other$isWindowTerminatedEarly)) {
            return false;
        }
        TimeWindow this$window = this.getWindow();
        TimeWindow other$window = other.getWindow();
        if (this$window == null ? other$window != null : !((Object)this$window).equals(other$window)) {
            return false;
        }
        Map<String, String> this$state = this.getState();
        Map<String, String> other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$shardId = this.getShardId();
        String other$shardId = other.getShardId();
        if (this$shardId == null ? other$shardId != null : !this$shardId.equals(other$shardId)) {
            return false;
        }
        String this$eventSourceArn = this.getEventSourceArn();
        String other$eventSourceArn = other.getEventSourceArn();
        return !(this$eventSourceArn == null ? other$eventSourceArn != null : !this$eventSourceArn.equals(other$eventSourceArn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamodbTimeWindowEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isFinalInvokeForWindow = this.getIsFinalInvokeForWindow();
        result = result * 59 + ($isFinalInvokeForWindow == null ? 43 : ((Object)$isFinalInvokeForWindow).hashCode());
        Boolean $isWindowTerminatedEarly = this.getIsWindowTerminatedEarly();
        result = result * 59 + ($isWindowTerminatedEarly == null ? 43 : ((Object)$isWindowTerminatedEarly).hashCode());
        TimeWindow $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        Map<String, String> $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $shardId = this.getShardId();
        result = result * 59 + ($shardId == null ? 43 : $shardId.hashCode());
        String $eventSourceArn = this.getEventSourceArn();
        result = result * 59 + ($eventSourceArn == null ? 43 : $eventSourceArn.hashCode());
        return result;
    }

    public static class DynamodbTimeWindowEventBuilder {
        private List<DynamodbEvent.DynamodbStreamRecord> records;
        private TimeWindow window;
        private Map<String, String> state;
        private String shardId;
        private String eventSourceArn;
        private Boolean isFinalInvokeForWindow;
        private Boolean isWindowTerminatedEarly;

        DynamodbTimeWindowEventBuilder() {
        }

        public DynamodbTimeWindowEventBuilder withRecords(List<DynamodbEvent.DynamodbStreamRecord> records) {
            this.records = records;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withWindow(TimeWindow window) {
            this.window = window;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withState(Map<String, String> state) {
            this.state = state;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withShardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withIsFinalInvokeForWindow(Boolean isFinalInvokeForWindow) {
            this.isFinalInvokeForWindow = isFinalInvokeForWindow;
            return this;
        }

        public DynamodbTimeWindowEventBuilder withIsWindowTerminatedEarly(Boolean isWindowTerminatedEarly) {
            this.isWindowTerminatedEarly = isWindowTerminatedEarly;
            return this;
        }

        public DynamodbTimeWindowEvent build() {
            return new DynamodbTimeWindowEvent(this.records, this.window, this.state, this.shardId, this.eventSourceArn, this.isFinalInvokeForWindow, this.isWindowTerminatedEarly);
        }

        public String toString() {
            return "DynamodbTimeWindowEvent.DynamodbTimeWindowEventBuilder(records=" + this.records + ", window=" + this.window + ", state=" + this.state + ", shardId=" + this.shardId + ", eventSourceArn=" + this.eventSourceArn + ", isFinalInvokeForWindow=" + this.isFinalInvokeForWindow + ", isWindowTerminatedEarly=" + this.isWindowTerminatedEarly + ")";
        }
    }
}

