/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletRequestHandledEvent;
import org.springframework.web.servlet.DispatcherServlet;

public class LambdaSpringApplicationInitializer
implements WebApplicationInitializer {
    public static final String ERROR_NO_CONTEXT = "No application context or configuration classes provided";
    private static final String DEFAULT_SERVLET_NAME = "aws-servless-java-container";
    private ConfigurableWebApplicationContext applicationContext;
    private boolean refreshContext = true;
    private List<ServletContextListener> contextListeners = new ArrayList<ServletContextListener>();
    private ServletConfig dispatcherConfig;
    private DispatcherServlet dispatcherServlet;
    private HttpServletResponse currentResponse;

    public LambdaSpringApplicationInitializer(ConfigurableWebApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void addListener(ServletContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void setRefreshContext(boolean refreshContext) {
        this.refreshContext = refreshContext;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.currentResponse = response;
        this.dispatcherServlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        this.applicationContext.setServletContext(servletContext);
        this.dispatcherConfig = new DefaultDispatcherConfig(servletContext);
        this.applicationContext.setServletConfig(this.dispatcherConfig);
        this.applicationContext.addApplicationListener((ApplicationListener)new ApplicationListener<ServletRequestHandledEvent>(){

            public void onApplicationEvent(ServletRequestHandledEvent servletRequestHandledEvent) {
                try {
                    LambdaSpringApplicationInitializer.this.currentResponse.flushBuffer();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Could not flush response buffer", e);
                }
            }
        });
        this.addListener((ServletContextListener)new ContextLoaderListener((WebApplicationContext)this.applicationContext));
        this.dispatcherServlet = new DispatcherServlet((WebApplicationContext)this.applicationContext);
        if (this.refreshContext) {
            this.dispatcherServlet.refresh();
        }
        this.dispatcherServlet.onApplicationEvent(new ContextRefreshedEvent((ApplicationContext)this.applicationContext));
        this.dispatcherServlet.init(this.dispatcherConfig);
        this.notifyStartListeners(servletContext);
    }

    private void notifyStartListeners(ServletContext context) {
        for (ServletContextListener listener : this.contextListeners) {
            listener.contextInitialized(new ServletContextEvent(context));
        }
    }

    private class DefaultDispatcherConfig
    implements ServletConfig {
        private ServletContext servletContext;

        DefaultDispatcherConfig(ServletContext context) {
            this.servletContext = context;
        }

        public String getServletName() {
            return LambdaSpringApplicationInitializer.DEFAULT_SERVLET_NAME;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public String getInitParameter(String s) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.emptyEnumeration();
        }
    }
}

