/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.internal.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.internal.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.spring.LambdaSpringApplicationInitializer;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SpringLambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, AwsProxyHttpServletRequest, AwsHttpServletResponse> {
    private LambdaSpringApplicationInitializer initializer;
    private boolean initialized;

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(Class ... config) throws ContainerInitializationException {
        AnnotationConfigWebApplicationContext applicationContext = new AnnotationConfigWebApplicationContext();
        applicationContext.register(config);
        return new SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>((RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), (ConfigurableWebApplicationContext)applicationContext);
    }

    public static SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler(ConfigurableWebApplicationContext applicationContext) throws ContainerInitializationException {
        return new SpringLambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>((RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), applicationContext);
    }

    public SpringLambdaContainerHandler(RequestReader<RequestType, AwsProxyHttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, ConfigurableWebApplicationContext applicationContext) throws ContainerInitializationException {
        super(requestReader, responseWriter, securityContextWriter, exceptionHandler);
        this.initializer = new LambdaSpringApplicationInitializer(applicationContext);
    }

    public void setRefreshContext(boolean refreshContext) {
        this.initializer.setRefreshContext(refreshContext);
    }

    protected AwsHttpServletResponse getContainerResponse(AwsProxyHttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse((AwsHttpServletRequest)request, latch);
    }

    public void activateSpringProfiles(String ... profiles) throws ContainerInitializationException {
        if (this.initializer == null) {
            throw new ContainerInitializationException("No application context or configuration classes provided", null);
        }
        this.initializer.setSpringProfiles(Arrays.asList(profiles));
    }

    protected void handleRequest(AwsProxyHttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
        if (this.initializer == null) {
            throw new ContainerInitializationException("No application context or configuration classes provided", null);
        }
        super.handleRequest((HttpServletRequest)containerRequest, (HttpServletResponse)containerResponse, lambdaContext);
        if (!this.initialized) {
            this.initializer.onStartup(this.getServletContext());
            if (this.startupHandler != null) {
                this.startupHandler.onStartup(this.getServletContext());
            }
            this.initialized = true;
        }
        containerRequest.setServletContext(this.getServletContext());
        this.doFilter((HttpServletRequest)containerRequest, (HttpServletResponse)containerResponse, (Servlet)this.initializer);
    }
}

