/*
 * Decompiled with CFR 0.152.
 */
package com.andrebreves.java.tuple;

import com.andrebreves.java.tuple.Tuple;
import java.util.Objects;

public final class Tuple2<T1, T2>
implements Tuple,
Comparable<Tuple2<T1, T2>> {
    private final T1 v1;
    private final T2 v2;

    private Tuple2(T1 v1, T2 v2) {
        this.v1 = v1;
        this.v2 = v2;
    }

    public static <T1, T2> Tuple2<T1, T2> of(T1 v1, T2 v2) {
        return new Tuple2<T1, T2>(v1, v2);
    }

    public T1 v1() {
        return this.v1;
    }

    public T2 v2() {
        return this.v2;
    }

    @Override
    public int degree() {
        return 2;
    }

    public int hashCode() {
        return Objects.hash(this.v1, this.v2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple2 other = (Tuple2)obj;
        return Objects.equals(this.v1, other.v1) && Objects.equals(this.v2, other.v2);
    }

    private static <T> int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        return ((Comparable)t1).compareTo(t2);
    }

    @Override
    public int compareTo(Tuple2<T1, T2> other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int result = Tuple2.compare(this.v1, other.v1);
        if (result != 0) {
            return result;
        }
        result = Tuple2.compare(this.v2, other.v2);
        if (result != 0) {
            return result;
        }
        return result;
    }
}

