/*
 * Decompiled with CFR 0.152.
 */
package com.andrebreves.java.tuple;

import com.andrebreves.java.tuple.Tuple;
import java.util.Objects;

public final class Tuple3<T1, T2, T3>
implements Tuple,
Comparable<Tuple3<T1, T2, T3>> {
    private final T1 v1;
    private final T2 v2;
    private final T3 v3;

    private Tuple3(T1 v1, T2 v2, T3 v3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
    }

    public static <T1, T2, T3> Tuple3<T1, T2, T3> of(T1 v1, T2 v2, T3 v3) {
        return new Tuple3<T1, T2, T3>(v1, v2, v3);
    }

    public T1 v1() {
        return this.v1;
    }

    public T2 v2() {
        return this.v2;
    }

    public T3 v3() {
        return this.v3;
    }

    @Override
    public int degree() {
        return 3;
    }

    public int hashCode() {
        return Objects.hash(this.v1, this.v2, this.v3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple3 other = (Tuple3)obj;
        return Objects.equals(this.v1, other.v1) && Objects.equals(this.v2, other.v2) && Objects.equals(this.v3, other.v3);
    }

    private static <T> int compare(T t1, T t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        return ((Comparable)t1).compareTo(t2);
    }

    @Override
    public int compareTo(Tuple3<T1, T2, T3> other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int result = Tuple3.compare(this.v1, other.v1);
        if (result != 0) {
            return result;
        }
        result = Tuple3.compare(this.v2, other.v2);
        if (result != 0) {
            return result;
        }
        result = Tuple3.compare(this.v3, other.v3);
        if (result != 0) {
            return result;
        }
        return result;
    }
}

