package com.pluto.plugins.exceptions.internal.persistence;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.pluto.plugins.exceptions.internal.DeviceInfo;
import com.pluto.plugins.exceptions.internal.ExceptionAllData;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalStateException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ExceptionDao_Impl implements ExceptionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ExceptionEntity> __insertionAdapterOfExceptionEntity;

  private final EntityConverters __entityConverters = new EntityConverters();

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public ExceptionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfExceptionEntity = new EntityInsertionAdapter<ExceptionEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `exceptions` (`id`,`timestamp`,`data`,`device`) VALUES (?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ExceptionEntity value) {
        if (value.getId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindLong(1, value.getId());
        }
        stmt.bindLong(2, value.getTimestamp());
        final String _tmp = __entityConverters.exceptionToString(value.getData());
        if (_tmp == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, _tmp);
        }
        final String _tmp_1 = __entityConverters.deviceToString(value.getDevice());
        if (_tmp_1 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_1);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM exceptions where id is ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM exceptions";
        return _query;
      }
    };
  }

  @Override
  public Object save(final ExceptionEntity entity, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfExceptionEntity.insert(entity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object delete(final int id, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, id);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object fetch(final int id, final Continuation<? super ExceptionEntity> continuation) {
    final String _sql = "SELECT * FROM exceptions where id is ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ExceptionEntity>() {
      @Override
      public ExceptionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "data");
          final int _cursorIndexOfDevice = CursorUtil.getColumnIndexOrThrow(_cursor, "device");
          final ExceptionEntity _result;
          if(_cursor.moveToFirst()) {
            final Integer _tmpId;
            if (_cursor.isNull(_cursorIndexOfId)) {
              _tmpId = null;
            } else {
              _tmpId = _cursor.getInt(_cursorIndexOfId);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final ExceptionAllData _tmpData;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfData)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfData);
            }
            final ExceptionAllData _tmp_1 = __entityConverters.stringToException(_tmp);
            if(_tmp_1 == null) {
              throw new IllegalStateException("Expected non-null com.pluto.plugins.exceptions.internal.ExceptionAllData, but it was null.");
            } else {
              _tmpData = _tmp_1;
            }
            final DeviceInfo _tmpDevice;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfDevice)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfDevice);
            }
            final DeviceInfo _tmp_3 = __entityConverters.stringToDevice(_tmp_2);
            if(_tmp_3 == null) {
              throw new IllegalStateException("Expected non-null com.pluto.plugins.exceptions.internal.DeviceInfo, but it was null.");
            } else {
              _tmpDevice = _tmp_3;
            }
            _result = new ExceptionEntity(_tmpId,_tmpTimestamp,_tmpData,_tmpDevice);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object fetchAll(final Continuation<? super List<ExceptionEntity>> continuation) {
    final String _sql = "SELECT * FROM exceptions order by timestamp DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ExceptionEntity>>() {
      @Override
      public List<ExceptionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "data");
          final int _cursorIndexOfDevice = CursorUtil.getColumnIndexOrThrow(_cursor, "device");
          final List<ExceptionEntity> _result = new ArrayList<ExceptionEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ExceptionEntity _item;
            final Integer _tmpId;
            if (_cursor.isNull(_cursorIndexOfId)) {
              _tmpId = null;
            } else {
              _tmpId = _cursor.getInt(_cursorIndexOfId);
            }
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            final ExceptionAllData _tmpData;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfData)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfData);
            }
            final ExceptionAllData _tmp_1 = __entityConverters.stringToException(_tmp);
            if(_tmp_1 == null) {
              throw new IllegalStateException("Expected non-null com.pluto.plugins.exceptions.internal.ExceptionAllData, but it was null.");
            } else {
              _tmpData = _tmp_1;
            }
            final DeviceInfo _tmpDevice;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfDevice)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfDevice);
            }
            final DeviceInfo _tmp_3 = __entityConverters.stringToDevice(_tmp_2);
            if(_tmp_3 == null) {
              throw new IllegalStateException("Expected non-null com.pluto.plugins.exceptions.internal.DeviceInfo, but it was null.");
            } else {
              _tmpDevice = _tmp_3;
            }
            _item = new ExceptionEntity(_tmpId,_tmpTimestamp,_tmpData,_tmpDevice);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
