package hope.common.spring.api;

import static hope.common.spring.api.Constants.API_ENABLE;
import static hope.common.spring.api.Constants.HOPE_API_PREFIX;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@ConditionalOnProperty(name = API_ENABLE, matchIfMissing = true)
@Lazy(false)
@Configuration(proxyBeanMethods = false)
@ConfigurationProperties(prefix = HOPE_API_PREFIX)
public class HopeApiProperties {

  /**
   * For custom path of the OpenAPI documentation in Json format <code>
   *     https://{service-url}/{context-path}/v3/api-docs{.json|yaml}
   * </code>
   */
  protected String path = "/v3/api-docs";

  /** whether to enable the open api swagger endpoint, in production used to disable this */
  protected boolean enable = true;

  /** whether expose this swagger.json to the */
  protected boolean showActuator = false;

  /** whether to show the meta information */
  protected boolean showMeta = true;

  /** the project information of this project */
  @NestedConfigurationProperty protected Project project = new Project();

  public String getPath() {
    return path;
  }

  public HopeApiProperties setPath(String path) {
    this.path = path;
    return this;
  }

  public boolean isEnable() {
    return enable;
  }

  public HopeApiProperties setEnable(boolean enable) {
    this.enable = enable;
    return this;
  }

  public boolean isShowActuator() {
    return showActuator;
  }

  public HopeApiProperties setShowActuator(boolean showActuator) {
    this.showActuator = showActuator;
    return this;
  }

  public Project getProject() {
    return project;
  }

  public HopeApiProperties setProject(Project project) {
    this.project = project;
    return this;
  }

  public boolean isShowMeta() {
    return showMeta;
  }

  public HopeApiProperties setShowMeta(boolean showMeta) {
    this.showMeta = showMeta;
    return this;
  }

  public static class Project {

    /**
     * the name of this project's API proto <code>
     *     "name" : "it-demo-user-proto",
     *     "description" : "用户模块",
     *     "application" : "it-demo-user",
     *     "packageName" : "com.bigger.user",
     * </code>
     */
    protected String name;

    /** whether always pick the latest version */
    protected boolean latest = true;

    /** if any specific version set, then use this one instead of the latest one */
    protected String version;

    public String getName() {
      return name;
    }

    public Project setName(String name) {
      this.name = name;
      return this;
    }

    public boolean isLatest() {
      return latest;
    }

    public Project setLatest(boolean latest) {
      this.latest = latest;
      return this;
    }

    public String getVersion() {
      return version;
    }

    public Project setVersion(String version) {
      this.version = version;
      return this;
    }
  }
}
