package hope.common.spring.api;

import static hope.common.spring.api.Constants.API_META_ENABLE;

import hope.common.spring.api.webflux.ApiMetaWebFluxResource;
import hope.common.spring.api.webmvc.ApiMetaWebMvcResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

/** this is shared properties */
@Lazy(false)
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(name = API_META_ENABLE, matchIfMissing = true)
@ConditionalOnWebApplication
@Import({ApiMetaWebFluxResource.class, ApiMetaWebMvcResource.class})
public class HopeMetaApiConfiguration {
}
