package hope.common.spring.api.provider;

import static hope.common.spring.api.Constants.API_ENABLE;

import hope.common.spring.api.HopeApiProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name = API_ENABLE, matchIfMissing = true)
public class ApiProviderManager {

  protected final ApplicationContext applicationContext;

  protected final HopeApiProperties hopeApiProperties;

  public ApiProviderManager(
      final ApplicationContext applicationContext, final HopeApiProperties hopeApiProperties) {
    this.applicationContext = applicationContext;
    this.hopeApiProperties = hopeApiProperties;
  }

  public ApiProvider provider() {
    //TODO should we get from the modules?

    String applicationName = applicationContext.getApplicationName();

    if (!StringUtils.hasText(applicationName)) {

      applicationName = applicationContext.getEnvironment().getProperty("spring.application.name");
    }

    final HopeApiProperties.Project project = hopeApiProperties.getProject();

    ResourcesApiProvider provider =
        new ResourcesApiProvider(applicationName, project.getVersion(), project.isLatest());
    return provider;
  }
}
