package hope.common.spring.api.webflux;

import static hope.common.spring.api.Constants.API_META_ENABLE;

import hope.common.spring.api.ApiMetaResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(name = API_META_ENABLE, matchIfMissing = true)
@RestController
public class ApiMetaWebFluxResource extends ApiMetaResource {

  public ApiMetaWebFluxResource(
      ApplicationContext applicationContext) {
    super(applicationContext);
  }

  @GetMapping(value = "/hope/meta/errors", produces = MediaType.APPLICATION_JSON_VALUE)
  public Mono<String> apiErrors() {
    return Mono.just(errors());
  }

  @GetMapping(value = "/hope/meta/dictionaries", produces = MediaType.APPLICATION_JSON_VALUE)
  public Mono<String> apiDictionaries() {
    return Mono.just(dictionaries());
  }

  @GetMapping(value = "/hope/meta/authorities", produces = MediaType.APPLICATION_JSON_VALUE)
  public Mono<String> apiAuthorities() {
    return Mono.just(authorities());
  }

  @GetMapping(value = "/hope/meta/versions", produces = MediaType.APPLICATION_JSON_VALUE)
  public Mono<String> apiVersions() {
    return Mono.just(versions());
  }
}
