package hope.common.spring.api.webmvc;

import static hope.common.spring.api.Constants.*;

import hope.common.spring.api.provider.ApiProvider;
import hope.common.spring.api.provider.ApiProviderManager;
import java.util.Locale;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;

@RestController
public class ApiWebMvcResource {

  protected final ApiProvider apiProvider;

  public ApiWebMvcResource(ApiProviderManager apiProviderManager) {
    apiProvider = apiProviderManager.provider();
  }

  @GetMapping(value = API_DOCS_URL, produces = MediaType.APPLICATION_JSON_VALUE)
  public String openapiJson(final NativeWebRequest request, final Locale locale) {
    // TODO the locale how to handle it?
    try {
      final String version = request.getParameter("version");
      if (StringUtils.hasText(version)) {
        return apiProvider.apiWithVersion(version.trim());
      }
    } catch (Throwable throwable) {
      // Omit
    }
    return apiProvider.api();
  }

  @GetMapping(value = API_DOCS_URL_YAML, produces = APPLICATION_OPENAPI_YAML)
  public String openapiYaml(final NativeWebRequest request, final Locale locale) {
    // TODO converter the json to the yaml and then return
    return "";
  }
}
