/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api.provider;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hope.common.api.exceptions.HopeErrorDetailException;
import hope.common.spring.api.Constants;
import hope.common.spring.api.provider.ApiProvider;
import hope.common.wire.errors.OASErrorsEnum;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class ResourcesApiProvider
implements ApiProvider,
Constants {
    protected final Logger logger = LoggerFactory.getLogger(ResourcesApiProvider.class);
    protected final String applicationName;
    protected final String version;
    protected final boolean latest;
    protected final ObjectMapper objectMapper = new ObjectMapper();

    public ResourcesApiProvider(String applicationName, String version, boolean latest) {
        this.applicationName = applicationName;
        this.version = version;
        this.latest = latest;
    }

    protected static String relativeJsonPath(String applicationName, String name) {
        return applicationName + "/swagger/" + name + ".json";
    }

    @Override
    public String api() {
        String calculateVersion = this.version;
        if (!StringUtils.hasText((String)this.version)) {
            calculateVersion = this.loadLatestVersion();
        }
        String path = ResourcesApiProvider.relativeJsonPath(this.applicationName, calculateVersion);
        try {
            String content = StreamUtils.copyToString((InputStream)this.getClass().getClassLoader().getResource(path).openStream(), (Charset)StandardCharsets.UTF_8);
            return content;
        }
        catch (Throwable e) {
            throw HopeErrorDetailException.builder().error(OASErrorsEnum.FAIL_READ_API_JSON).setMessage("fail read the version resource for application: [" + this.applicationName + "]  path: " + path).setCause(e).build();
        }
    }

    @Override
    public String apiWithVersion(String version) {
        return this.apiWithVersion(version);
    }

    protected String loadLatestVersion() {
        String versionPath = ResourcesApiProvider.relativeJsonPath(this.applicationName, "version");
        try {
            URL url = this.getClass().getClassLoader().getResource(versionPath);
            this.logger.debug("PROCESS_VERSION {}", (Object)url);
            JsonNode root = this.objectMapper.readTree(url);
            return this.pickLatestVersion(root);
        }
        catch (Throwable e) {
            throw HopeErrorDetailException.builder().error(OASErrorsEnum.FAIL_READ_API_VERSION).setMessage("fail read the version resource for application: [" + this.applicationName + "]  path: " + versionPath).setCause(e).build();
        }
    }

    protected String pickLatestVersion(JsonNode jsonNode) {
        JsonNode current = jsonNode.get("current");
        if (current != null) {
            return current.get("version").textValue();
        }
        return null;
    }
}

