/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api.webmvc;

import hope.common.spring.api.provider.ApiProvider;
import hope.common.spring.api.provider.ApiProviderManager;
import java.util.Locale;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;

@RestController
public class ApiWebMvcResource {
    protected final ApiProvider apiProvider;

    public ApiWebMvcResource(ApiProviderManager apiProviderManager) {
        this.apiProvider = apiProviderManager.provider();
    }

    @GetMapping(value={"${hope.open.api.path:#{T(hope.common.spring.api.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(NativeWebRequest request, Locale locale) {
        try {
            String version = request.getParameter("version");
            if (StringUtils.hasText((String)version)) {
                return this.apiProvider.apiWithVersion(version.trim());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.apiProvider.api();
    }

    @GetMapping(value={"${hope.open.api.path:#{T(hope.common.spring.api.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(NativeWebRequest request, Locale locale) {
        return "";
    }
}

