/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public abstract class ApiMetaResource
implements InitializingBean {
    protected static final String EMPTY = "{}";
    protected final ApplicationContext applicationContext;
    protected Logger logger = LoggerFactory.getLogger(ApiMetaResource.class);
    protected String applicationName;
    protected String errors;
    protected String authorities;
    protected String versions;
    protected String dictionaries;

    protected ApiMetaResource(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.applicationName = this.applicationContext.getApplicationName();
        if (!StringUtils.hasText((String)this.applicationName)) {
            this.applicationName = this.applicationContext.getEnvironment().getProperty("spring.application.name");
        }
    }

    private String safeLoadMeta(String name) {
        String path = this.applicationName + "/hope-domain-" + name + ".json";
        try {
            return StreamUtils.copyToString((InputStream)this.getClass().getClassLoader().getResource(path).openStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            this.logger.warn("FAIL_LOAD " + path, throwable);
            return EMPTY;
        }
    }

    protected String safeApiByVersion(String version) {
        String path = this.applicationName + "/swagger/" + version + ".json";
        try {
            return StreamUtils.copyToString((InputStream)this.getClass().getClassLoader().getResource(path).openStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            this.logger.warn("FAIL_LOAD_API_BY_VERSION " + path, throwable);
            return EMPTY;
        }
    }

    private String safeLoadVersions() {
        String path = this.applicationName + "/swagger/version.json";
        try {
            return StreamUtils.copyToString((InputStream)this.getClass().getClassLoader().getResource(path).openStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            this.logger.warn("FAIL_LOAD " + path, throwable);
            return EMPTY;
        }
    }

    protected String dictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = this.safeLoadMeta("dictionaries");
        }
        return this.dictionaries;
    }

    protected String errors() {
        if (this.errors == null) {
            this.errors = this.safeLoadMeta("errors");
        }
        return this.errors;
    }

    protected String authorities() {
        if (this.authorities == null) {
            this.authorities = this.safeLoadMeta("authorities");
        }
        return this.authorities;
    }

    protected String versions() {
        if (this.versions == null) {
            this.versions = this.safeLoadVersions();
        }
        return this.versions;
    }
}

