package hope.common.spring.api.webmvc;

import hope.common.spring.api.ApiMetaResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import static hope.common.spring.api.Constants.API_META_ENABLE;

@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name = API_META_ENABLE, matchIfMissing = true)
@RestController
public class ApiMetaWebMvcResource extends ApiMetaResource {

  public ApiMetaWebMvcResource(ApplicationContext applicationContext) {
    super(applicationContext);
  }

  @GetMapping(value = "/hope/meta/errors", produces = MediaType.APPLICATION_JSON_VALUE)
  public String apiErrors() {
    return errors();
  }

  @GetMapping(value = "/hope/meta/dictionaries", produces = MediaType.APPLICATION_JSON_VALUE)
  public String apiDictionaries() {
    return dictionaries();
  }

  @GetMapping(value = "/hope/meta/authorities", produces = MediaType.APPLICATION_JSON_VALUE)
  public String apiAuthorities() {
    return authorities();
  }

  @GetMapping(value = "/hope/meta/versions", produces = MediaType.APPLICATION_JSON_VALUE)
  public String apiVersions() {
    return versions();
  }
}
