package hope.common.spring.api.webflux;

import static hope.common.spring.api.Constants.*;

import hope.common.spring.api.provider.ApiProvider;
import hope.common.spring.api.provider.ApiProviderManager;
import java.util.Locale;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class ApiWebFluxResource {

  protected final ApiProvider apiProvider;

  public ApiWebFluxResource(ApiProviderManager apiProviderManager) {
    apiProvider = apiProviderManager.provider();
  }

  @GetMapping(value = API_DOCS_URL, produces = MediaType.APPLICATION_JSON_VALUE)
  public Mono<String> openapiJson(final ServerHttpRequest request, final Locale locale) {

    try {
      final String version = request.getQueryParams().getFirst("version");
      if (StringUtils.hasText(version)) {
        return Mono.just(apiProvider.apiWithVersion(version.trim()));
      }
    } catch (Throwable throwable) {

    }
    // TODO the locale how to handle it?
    return Mono.just(apiProvider.api());
  }

  @GetMapping(value = API_DOCS_URL_YAML, produces = APPLICATION_OPENAPI_YAML)
  public Mono<String> openapiYaml(final ServerHttpRequest request, final Locale locale) {
    // TODO converter the json to the yaml and then return
    return Mono.just("");
  }
}
