/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@ConditionalOnProperty(name={"hope.open.api.enable"}, matchIfMissing=true)
@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConfigurationProperties(prefix="hope.open.api")
public class HopeApiProperties {
    protected String path = "/v3/api-docs";
    protected boolean enable = true;
    protected boolean showActuator = false;
    protected boolean showMeta = true;
    @NestedConfigurationProperty
    protected Project project = new Project();

    public String getPath() {
        return this.path;
    }

    public HopeApiProperties setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public HopeApiProperties setEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public boolean isShowActuator() {
        return this.showActuator;
    }

    public HopeApiProperties setShowActuator(boolean showActuator) {
        this.showActuator = showActuator;
        return this;
    }

    public Project getProject() {
        return this.project;
    }

    public HopeApiProperties setProject(Project project) {
        this.project = project;
        return this;
    }

    public boolean isShowMeta() {
        return this.showMeta;
    }

    public HopeApiProperties setShowMeta(boolean showMeta) {
        this.showMeta = showMeta;
        return this;
    }

    public static class Project {
        protected String name;
        protected boolean latest = true;
        protected String version;

        public String getName() {
            return this.name;
        }

        public Project setName(String name) {
            this.name = name;
            return this;
        }

        public boolean isLatest() {
            return this.latest;
        }

        public Project setLatest(boolean latest) {
            this.latest = latest;
            return this;
        }

        public String getVersion() {
            return this.version;
        }

        public Project setVersion(String version) {
            this.version = version;
            return this;
        }
    }
}

