/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api.provider;

import hope.common.spring.api.HopeApiProperties;
import hope.common.spring.api.provider.ApiProvider;
import hope.common.spring.api.provider.ResourcesApiProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"hope.open.api.enable"}, matchIfMissing=true)
public class ApiProviderManager {
    protected final ApplicationContext applicationContext;
    protected final HopeApiProperties hopeApiProperties;

    public ApiProviderManager(ApplicationContext applicationContext, HopeApiProperties hopeApiProperties) {
        this.applicationContext = applicationContext;
        this.hopeApiProperties = hopeApiProperties;
    }

    public ApiProvider provider() {
        String applicationName = this.applicationContext.getApplicationName();
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = this.applicationContext.getEnvironment().getProperty("spring.application.name");
        }
        HopeApiProperties.Project project = this.hopeApiProperties.getProject();
        ResourcesApiProvider provider = new ResourcesApiProvider(applicationName, project.getVersion(), project.isLatest());
        return provider;
    }
}

