/*
 * Decompiled with CFR 0.152.
 */
package hope.common.spring.api.webflux;

import hope.common.spring.api.provider.ApiProvider;
import hope.common.spring.api.provider.ApiProviderManager;
import java.util.Locale;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
public class ApiWebFluxResource {
    protected final ApiProvider apiProvider;

    public ApiWebFluxResource(ApiProviderManager apiProviderManager) {
        this.apiProvider = apiProviderManager.provider();
    }

    @GetMapping(value={"${hope.open.api.path:#{T(hope.common.spring.api.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public Mono<String> openapiJson(ServerHttpRequest request, Locale locale) {
        try {
            String version = (String)request.getQueryParams().getFirst((Object)"version");
            if (StringUtils.hasText((String)version)) {
                return Mono.just((Object)this.apiProvider.apiWithVersion(version.trim()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Mono.just((Object)this.apiProvider.api());
    }

    @GetMapping(value={"${hope.open.api.path:#{T(hope.common.spring.api.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public Mono<String> openapiYaml(ServerHttpRequest request, Locale locale) {
        return Mono.just((Object)"");
    }
}

